/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import net.jini.core.constraint.ArraySet;
import net.jini.core.constraint.Constraint;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.RelativeTimeConstraint;

public final class InvocationConstraints
implements Serializable {
    private static final long serialVersionUID = -3363161199079334224L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("reqs", InvocationConstraint[].class, true), new ObjectStreamField("prefs", InvocationConstraint[].class, true)};
    private static final InvocationConstraint[] empty = new InvocationConstraint[0];
    private static final int REL_REQS = 1;
    private static final int REL_PREFS = 2;
    public static final InvocationConstraints EMPTY = new InvocationConstraints((InvocationConstraint)null, null);
    private InvocationConstraint[] reqs;
    private InvocationConstraint[] prefs;
    private transient int rel = 0;

    public InvocationConstraints(InvocationConstraint req, InvocationConstraint pref) {
        if (req != null) {
            this.reqs = new InvocationConstraint[]{req};
        }
        if (pref != null) {
            this.prefs = new InvocationConstraint[]{pref};
        }
        this.reduce();
    }

    public InvocationConstraints(InvocationConstraint[] reqs, InvocationConstraint[] prefs) {
        if (reqs != null) {
            this.reqs = (InvocationConstraint[])reqs.clone();
        }
        if (prefs != null) {
            this.prefs = (InvocationConstraint[])prefs.clone();
        }
        this.reduce();
    }

    public InvocationConstraints(Collection reqs, Collection prefs) {
        try {
            if (reqs != null) {
                this.reqs = reqs.toArray(new InvocationConstraint[reqs.size()]);
            }
            if (prefs != null) {
                this.prefs = prefs.toArray(new InvocationConstraint[prefs.size()]);
            }
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException("element of collection is not an InvocationConstraint");
        }
        this.reduce();
    }

    private InvocationConstraints(InvocationConstraint[] reqs, int reqidx, InvocationConstraint[] prefs, int prefidx, int rel) {
        this.reqs = reqs;
        this.prefs = prefs;
        this.reduce(reqidx, prefidx);
        this.rel = rel;
    }

    private void reduce() {
        if (this.reqs == null) {
            this.reqs = empty;
        }
        if (this.prefs == null) {
            this.prefs = empty;
        }
        this.reduce(0, 0);
        this.setRelative(this.reqs, 1);
        this.setRelative(this.prefs, 2);
    }

    private void reduce(int reqidx, int prefidx) {
        int i;
        for (i = reqidx; i < this.reqs.length; ++i) {
            InvocationConstraint req = this.reqs[i];
            if (req == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(this.reqs, reqidx, req)) continue;
            this.reqs[reqidx++] = req;
        }
        this.reqs = (InvocationConstraint[])Constraint.trim(this.reqs, reqidx);
        for (i = prefidx; i < this.prefs.length; ++i) {
            InvocationConstraint pref = this.prefs[i];
            if (pref == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(this.prefs, prefidx, pref) || Constraint.contains(this.reqs, this.reqs.length, pref)) continue;
            this.prefs[prefidx++] = pref;
        }
        this.prefs = (InvocationConstraint[])Constraint.trim(this.prefs, prefidx);
    }

    private static boolean relative(InvocationConstraint c) {
        return c instanceof RelativeTimeConstraint && (!(c instanceof ConstraintAlternatives) || ((ConstraintAlternatives)c).relative());
    }

    private void setRelative(InvocationConstraint[] constraints, int flag) {
        int i = constraints.length;
        while (--i >= 0) {
            if (!InvocationConstraints.relative(constraints[i])) continue;
            this.rel |= flag;
            return;
        }
    }

    public static InvocationConstraints combine(InvocationConstraints constraints1, InvocationConstraints constraints2) {
        int prefidx;
        InvocationConstraint[] reqs;
        if (constraints1 == null || constraints1.isEmpty()) {
            return constraints2 == null ? EMPTY : constraints2;
        }
        if (constraints2 == null || constraints2.isEmpty()) {
            return constraints1;
        }
        if (constraints2.reqs.length > constraints1.reqs.length) {
            InvocationConstraints tmp = constraints1;
            constraints1 = constraints2;
            constraints2 = tmp;
        }
        if (constraints2.reqs.length > 0) {
            reqs = InvocationConstraints.concat(constraints1.reqs, constraints2.reqs);
            prefidx = 0;
        } else {
            reqs = constraints1.reqs;
            prefidx = constraints1.prefs.length;
        }
        InvocationConstraint[] prefs = constraints1.prefs.length > 0 || constraints2.prefs.length > 0 ? InvocationConstraints.concat(constraints1.prefs, constraints2.prefs) : empty;
        return new InvocationConstraints(reqs, constraints1.reqs.length, prefs, prefidx, constraints1.rel | constraints2.rel);
    }

    private static InvocationConstraint[] concat(InvocationConstraint[] arr1, InvocationConstraint[] arr2) {
        InvocationConstraint[] res = new InvocationConstraint[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, res, 0, arr1.length);
        System.arraycopy(arr2, 0, res, arr1.length, arr2.length);
        return res;
    }

    private static InvocationConstraint[] makeAbsolute(InvocationConstraint[] arr, long baseTime) {
        InvocationConstraint[] narr = new InvocationConstraint[arr.length];
        int i = arr.length;
        while (--i >= 0) {
            InvocationConstraint c = arr[i];
            if (c instanceof RelativeTimeConstraint) {
                c = ((RelativeTimeConstraint)c).makeAbsolute(baseTime);
            }
            narr[i] = c;
        }
        return narr;
    }

    public InvocationConstraints makeAbsolute(long baseTime) {
        int reqidx;
        InvocationConstraint[] nreqs;
        if (this.rel == 0) {
            return this;
        }
        if ((this.rel & 1) != 0) {
            nreqs = InvocationConstraints.makeAbsolute(this.reqs, baseTime);
            reqidx = 0;
        } else {
            nreqs = this.reqs;
            reqidx = this.reqs.length;
        }
        InvocationConstraint[] nprefs = (this.rel & 2) != 0 ? InvocationConstraints.makeAbsolute(this.prefs, baseTime) : (InvocationConstraint[])this.prefs.clone();
        return new InvocationConstraints(nreqs, reqidx, nprefs, 0, 0);
    }

    public InvocationConstraints makeAbsolute() {
        if (this.rel == 0) {
            return this;
        }
        return this.makeAbsolute(System.currentTimeMillis());
    }

    public Set requirements() {
        return new ArraySet(this.reqs);
    }

    public Set preferences() {
        return new ArraySet(this.prefs);
    }

    public boolean isEmpty() {
        return this.reqs.length == 0 && this.prefs.length == 0;
    }

    public int hashCode() {
        return Constraint.hash(this.reqs) + Constraint.hash(this.prefs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvocationConstraints)) {
            return false;
        }
        InvocationConstraints sc = (InvocationConstraints)obj;
        return Constraint.equal(this.reqs, sc.reqs) && Constraint.equal(this.prefs, sc.prefs);
    }

    public String toString() {
        return "InvocationConstraints[reqs: " + Constraint.toString(this.reqs) + ", prefs: " + Constraint.toString(this.prefs) + "]";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        InvocationConstraints.verify(this.reqs);
        InvocationConstraints.verify(this.prefs);
        int i = this.prefs.length;
        while (--i >= 0) {
            if (!Constraint.contains(this.reqs, this.reqs.length, this.prefs[i])) continue;
            throw new InvalidObjectException("cannot create constraint with redundant elements");
        }
        this.setRelative(this.reqs, 1);
        this.setRelative(this.prefs, 1);
    }

    private static void verify(InvocationConstraint[] constraints) throws InvalidObjectException {
        if (constraints == null) {
            throw new InvalidObjectException("array cannot be null");
        }
        int i = constraints.length;
        while (--i >= 0) {
            InvocationConstraint c = constraints[i];
            if (c == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (!Constraint.contains(constraints, i, c)) continue;
            throw new InvalidObjectException("cannot create constraint with redundant elements");
        }
    }
}

