/*
 * Decompiled with CFR 0.152.
 */
package net.jini.url.httpmd;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jini.url.httpmd.HttpmdURLConnection;
import net.jini.url.httpmd.HttpmdUtil;

public class Handler
extends URLStreamHandler {
    protected int getDefaultPort() {
        return 80;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        return new HttpmdURLConnection(u);
    }

    protected void parseURL(URL url, String spec, int start, int limit) {
        int length;
        int comment;
        if (start < limit && spec.charAt(start) == ',') {
            String path;
            int param;
            String query = url.getQuery();
            int queryStart = spec.indexOf(63, start);
            if (queryStart != -1) {
                query = spec.substring(queryStart + 1, limit);
                limit = queryStart;
            }
            if ((param = (path = url.getPath() == null ? "" : url.getPath()).lastIndexOf(59)) != -1) {
                int equalsIndex = path.indexOf(61, param);
                if (equalsIndex < 0) {
                    throw new IllegalArgumentException("Message digest parameter is missing a '='");
                }
                comment = path.indexOf(44, equalsIndex);
                if (comment != -1) {
                    path = path.substring(0, comment);
                }
            }
            path = path + spec.substring(start, limit);
            this.setURL(url, url.getProtocol(), url.getHost(), url.getPort(), url.getAuthority(), url.getUserInfo(), path, query, url.getRef());
        } else {
            super.parseURL(url, spec, start, limit);
        }
        String path = url.getPath() == null ? "" : url.getPath();
        int semiIndex = path.lastIndexOf(59);
        if (semiIndex < 0) {
            throw new IllegalArgumentException("Message digest parameter is missing");
        }
        int equalsIndex = path.indexOf(61, semiIndex);
        if (equalsIndex < 0) {
            throw new IllegalArgumentException("Message digest parameter is missing a '='");
        }
        String algorithm = path.substring(semiIndex + 1, equalsIndex);
        try {
            MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest parameter algorithm is not found: " + algorithm);
        }
        String digest = path.substring(equalsIndex + 1);
        comment = digest.indexOf(44);
        if (comment != -1) {
            int i = digest.length();
            while (--i > comment) {
                char c = digest.charAt(i);
                if (HttpmdUtil.commentChar(c)) continue;
                throw new IllegalArgumentException("Comment contains illegal character: '" + c + "'");
            }
            digest = digest.substring(0, comment);
        }
        if ((length = digest.length()) == 0) {
            throw new IllegalArgumentException("Message digest parameter digest is empty");
        }
        int i = length;
        while (--i >= 0) {
            char c = digest.charAt(i);
            if (Character.digit(c, 16) >= 0) continue;
            throw new IllegalArgumentException("Message digest parameter has invalid hex character: " + c);
        }
    }

    protected boolean sameFile(URL u1, URL u2) {
        int port2;
        String path2;
        if (!(u1.getProtocol() == u2.getProtocol() || u1.getProtocol() != null && u1.getProtocol().equalsIgnoreCase(u2.getProtocol()))) {
            return false;
        }
        if (!this.hostsEqual(u1, u2)) {
            return false;
        }
        String path1 = u1.getPath();
        if (path1 != (path2 = u2.getPath())) {
            if (path1 == null || path2 == null) {
                return false;
            }
            if (!path1.equals(path2)) {
                int len2;
                int param = path1.lastIndexOf(59);
                if (param < 0 || param != path2.lastIndexOf(59)) {
                    return false;
                }
                if (!path1.regionMatches(0, path2, 0, param)) {
                    return false;
                }
                int equalsIndex = path1.indexOf(61, param + 1);
                if (equalsIndex < 0 || equalsIndex != path2.lastIndexOf(61)) {
                    return false;
                }
                int comment1 = path1.indexOf(44, equalsIndex + 1);
                int len = comment1 != -1 ? comment1 : path1.length();
                int comment2 = path2.indexOf(44, equalsIndex + 1);
                int n = len2 = comment2 != -1 ? comment2 : path2.length();
                if (len != len2) {
                    return false;
                }
                if (!path1.regionMatches(true, param + 1, path2, param + 1, len - param - 1)) {
                    return false;
                }
            }
        }
        if (u1.getQuery() == null ? u2.getQuery() != null : !u1.getQuery().equals(u2.getQuery())) {
            return false;
        }
        int port1 = u1.getPort() != -1 ? u1.getPort() : u1.getDefaultPort();
        int n = port2 = u2.getPort() != -1 ? u2.getPort() : u2.getDefaultPort();
        return port1 == port2;
    }

    protected int hashCode(URL u) {
        String query;
        InetAddress addr;
        int h = 0;
        String protocol = u.getProtocol();
        if (protocol != null) {
            h += protocol.hashCode();
        }
        if ((addr = this.getHostAddress(u)) != null) {
            h += addr.hashCode();
        } else {
            String host = u.getHost();
            if (host != null) {
                h += host.toLowerCase().hashCode();
            }
        }
        String path = u.getPath();
        if (path != null) {
            int param = path.lastIndexOf(59);
            if (param == -1) {
                h += path.hashCode();
            } else {
                h += path.substring(0, param).hashCode();
                int equalsIndex = path.indexOf(61, param + 1);
                int comment = path.indexOf(44, equalsIndex != -1 ? equalsIndex : param + 1);
                if (comment != -1) {
                    path = path.substring(0, comment);
                }
                h += path.substring(param).toLowerCase().hashCode();
            }
        }
        if ((query = u.getQuery()) != null) {
            h += query.hashCode();
        }
        h = u.getPort() == -1 ? (h += this.getDefaultPort()) : (h += u.getPort());
        String ref = u.getRef();
        if (ref != null) {
            h += ref.hashCode();
        }
        return h;
    }
}

