/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class GrantPermission
extends Permission {
    private static final long serialVersionUID = 4668259055340724280L;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};
    private transient Permission[] grants;
    private transient boolean unserializable;
    private volatile transient Implier implier;
    private volatile transient Integer hash;

    public GrantPermission(String name) {
        super(name);
        this.initFromName(name);
    }

    public GrantPermission(Permission permission) {
        this(new Permission[]{permission});
    }

    public GrantPermission(Permission[] permissions) {
        permissions = (Permission[])permissions.clone();
        super(GrantPermission.constructName(permissions));
        this.grants = GrantPermission.flatten(permissions);
        for (int i = 0; i < permissions.length; ++i) {
            if (!(permissions[i] instanceof UnresolvedPermission)) continue;
            this.unserializable = true;
            return;
        }
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new GrantPermissionCollection();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof GrantPermission)) {
            return false;
        }
        if (this.implier == null) {
            Implier imp = new Implier();
            imp.add(this);
            this.implier = imp;
        }
        return this.implier.implies(permission);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GrantPermission) {
            GrantPermission gp = (GrantPermission)obj;
            return this.implies(gp) && gp.implies(this);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = new Integer(this.computeHashCode());
        }
        return this.hash;
    }

    private int computeHashCode() {
        int sum = 0;
        HashSet<String> set = new HashSet<String>(this.grants.length);
        for (int i = 0; i < this.grants.length; ++i) {
            Permission p = this.grants[i];
            String pcn = p.getClass().getName();
            if (p instanceof AllPermission) {
                return pcn.hashCode();
            }
            if (p instanceof UnresolvedPermission) {
                pcn = pcn + ":" + p.getName();
            }
            if (set.contains(pcn)) continue;
            set.add(pcn);
            sum += pcn.hashCode();
        }
        return sum;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.unserializable) {
            throw new NotSerializableException(GrantPermission.class.getName());
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.initFromName(this.getName());
        }
        catch (RuntimeException e) {
            if (e instanceof NullPointerException || e instanceof IllegalArgumentException) {
                InvalidObjectException ee = new InvalidObjectException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
            throw e;
        }
    }

    private void initFromName(String name) {
        PermissionInfo[] pia = GrantPermission.parsePermissions(name);
        ArrayList<UnresolvedPermission> l = new ArrayList<UnresolvedPermission>();
        for (int i = 0; i < pia.length; ++i) {
            Constructor<?> c;
            Class<?> cl;
            int d;
            PermissionInfo pi = pia[i];
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (d = pi.type.lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(pi.type.substring(0, d));
            }
            try {
                cl = Class.forName(pi.type);
            }
            catch (ClassNotFoundException ex) {
                l.add(new UnresolvedPermission(pi.type, pi.name, pi.actions, null));
                continue;
            }
            if (!Permission.class.isAssignableFrom(cl)) {
                throw new IllegalArgumentException("not a permission class: " + cl);
            }
            if (!Modifier.isPublic(cl.getModifiers())) {
                throw new IllegalArgumentException("non-public permission class: " + cl);
            }
            if (pi.name == null) {
                try {
                    c = cl.getConstructor(PARAMS0);
                    l.add((UnresolvedPermission)c.newInstance(new Object[0]));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (pi.actions == null) {
                try {
                    c = cl.getConstructor(PARAMS1);
                    l.add((UnresolvedPermission)c.newInstance(pi.name));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            try {
                c = cl.getConstructor(PARAMS2);
                l.add((UnresolvedPermission)c.newInstance(pi.name, pi.actions));
                continue;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("uninstantiable permission class: " + cl);
            }
        }
        this.grants = GrantPermission.flatten(l.toArray(new Permission[l.size()]));
    }

    private static PermissionInfo[] parsePermissions(String s) {
        try {
            ArrayList<PermissionInfo> l = new ArrayList<PermissionInfo>();
            StreamTokenizer st = GrantPermission.createTokenizer(s);
            int delim = 34;
            if (st.nextToken() == -3 && st.sval.equals("delim")) {
                if (st.nextToken() == 61) {
                    if (st.nextToken() == -3) {
                        if (st.sval.length() > 1) {
                            throw new IllegalArgumentException("excess delimiter characters");
                        }
                        delim = st.sval.charAt(0);
                    } else {
                        delim = (char)st.ttype;
                    }
                    if (delim == 59) {
                        throw new IllegalArgumentException("illegal delimiter ';'");
                    }
                } else {
                    st = GrantPermission.createTokenizer(s);
                }
                st.nextToken();
            }
            st.quoteChar(delim);
            do {
                String name = null;
                String actions = null;
                if (st.ttype != -3) {
                    throw new IllegalArgumentException("expected permission type");
                }
                String type = st.sval;
                st.nextToken();
                if (st.ttype == -1 || st.ttype == 59) {
                    l.add(new PermissionInfo(type, null, null));
                    continue;
                }
                if (st.ttype != delim) {
                    throw new IllegalArgumentException("expected permission name or ';'");
                }
                name = st.sval;
                st.nextToken();
                if (st.ttype == -1 || st.ttype == 59) {
                    l.add(new PermissionInfo(type, name, null));
                    continue;
                }
                if (st.ttype != 44) {
                    throw new IllegalArgumentException("expected ',' or ';'");
                }
                if (st.nextToken() != delim) {
                    throw new IllegalArgumentException("expected permission actions");
                }
                actions = st.sval;
                st.nextToken();
                if (st.ttype == -1 || st.ttype == 59) {
                    l.add(new PermissionInfo(type, name, actions));
                    continue;
                }
                throw new IllegalArgumentException("expected ';'");
            } while (st.nextToken() != -1);
            return l.toArray(new PermissionInfo[l.size()]);
        }
        catch (IOException ex) {
            throw (Error)new InternalError().initCause(ex);
        }
    }

    private static StreamTokenizer createTokenizer(String s) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.resetSyntax();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.wordChars(160, 255);
        st.whitespaceChars(0, 32);
        st.lowerCaseMode(false);
        st.ordinaryChar(47);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        return st;
    }

    private static String constructName(Permission[] pa) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pa.length; ++i) {
            Permission p = pa[i];
            if (p instanceof UnresolvedPermission) {
                sb.append(p).append("; ");
                continue;
            }
            Class<?> cl = p.getClass();
            int nargs = GrantPermission.maxConsArgs(cl);
            String t = cl.getName();
            String n = p.getName();
            String a = p.getActions();
            if (nargs == 2 && a != null) {
                sb.append(t + " " + GrantPermission.quote(n) + ", " + GrantPermission.quote(a) + "; ");
                continue;
            }
            if (nargs >= 1 && n != null) {
                sb.append(t + " " + GrantPermission.quote(n) + "; ");
                continue;
            }
            sb.append(t + "; ");
        }
        return sb.toString().trim();
    }

    private static int maxConsArgs(Class cl) {
        try {
            cl.getConstructor(PARAMS2);
            return 2;
        }
        catch (Exception ex) {
            try {
                cl.getConstructor(PARAMS1);
                return 1;
            }
            catch (Exception ex2) {
                try {
                    cl.getConstructor(PARAMS0);
                    return 0;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
        }
    }

    private static String quote(String s) {
        StringBuffer sb = new StringBuffer(s.length() + 2);
        sb.append('\"');
        char[] ca = s.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char c = ca[i];
            if (c == '\\' || c == '\"') {
                sb.append("\\").append(c);
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c == '\f') {
                sb.append("\\f");
                continue;
            }
            if (c == '\b') {
                sb.append("\\b");
                continue;
            }
            if (c < ' ') {
                sb.append("\\").append(Integer.toOctalString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.append('\"').toString();
    }

    private static Permission[] flatten(Permission[] pa) {
        ArrayList<Permission> l = new ArrayList<Permission>(pa.length);
        for (int i = 0; i < pa.length; ++i) {
            Permission p = pa[i];
            if (p instanceof GrantPermission) {
                l.addAll(Arrays.asList(((GrantPermission)p).grants));
                continue;
            }
            l.add(p);
        }
        return l.toArray(new Permission[l.size()]);
    }

    static class GrantPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 8227621799817733985L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("perms", List.class, true)};
        private List perms = new ArrayList();
        private Implier implier = new Implier();

        GrantPermissionCollection() {
        }

        public synchronized void add(Permission p) {
            if (!(p instanceof GrantPermission)) {
                throw new IllegalArgumentException("invalid permission: " + p);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("can't add to read-only PermissionCollection");
            }
            this.perms.add(p);
            this.implier.add((GrantPermission)p);
        }

        public synchronized Enumeration elements() {
            return Collections.enumeration(this.perms);
        }

        public synchronized boolean implies(Permission p) {
            return this.implier.implies(p);
        }

        public synchronized void setReadOnly() {
            super.setReadOnly();
        }

        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            GrantPermission[] pa;
            s.defaultReadObject();
            if (this.perms == null) {
                throw new InvalidObjectException("list cannot be null");
            }
            if (!this.perms.getClass().equals(ArrayList.class)) {
                this.perms = new ArrayList(this.perms);
            }
            if (this.perms.contains(null)) {
                throw new InvalidObjectException("element must be a GrantPermission");
            }
            try {
                pa = this.perms.toArray(new GrantPermission[this.perms.size()]);
            }
            catch (ArrayStoreException e) {
                throw new InvalidObjectException("element must be a GrantPermission");
            }
            this.implier = new Implier();
            for (int i = 0; i < pa.length; ++i) {
                this.implier.add(pa[i]);
            }
        }
    }

    private static class Implier {
        private final PermissionCollection perms = new Permissions();
        private final ArrayList unresolved = new ArrayList();

        private Implier() {
        }

        void add(GrantPermission gp) {
            for (int i = 0; i < gp.grants.length; ++i) {
                Permission p = gp.grants[i];
                if (this.impliesContained(p)) continue;
                this.perms.add(p);
                if (!(p instanceof UnresolvedPermission)) continue;
                this.unresolved.add(p);
            }
        }

        boolean implies(Permission p) {
            if (!(p instanceof GrantPermission)) {
                return false;
            }
            Permission[] pa = ((GrantPermission)p).grants;
            for (int i = 0; i < pa.length; ++i) {
                if (this.impliesContained(pa[i])) continue;
                return false;
            }
            return true;
        }

        private boolean impliesContained(Permission p) {
            if (p instanceof UnresolvedPermission) {
                Iterator i = this.unresolved.iterator();
                while (i.hasNext()) {
                    if (!Implier.implies((UnresolvedPermission)i.next(), (UnresolvedPermission)p)) continue;
                    return true;
                }
                return false;
            }
            return this.perms.implies(p);
        }

        private static boolean implies(UnresolvedPermission p1, UnresolvedPermission p2) {
            if (p1 == p2) {
                return true;
            }
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                bout.reset();
                oout.writeObject(p1);
                oout.flush();
                byte[] b1 = bout.toByteArray();
                oout.reset();
                bout.reset();
                oout.writeObject(p2);
                oout.flush();
                byte[] b2 = bout.toByteArray();
                return Arrays.equals(b1, b2);
            }
            catch (IOException ex) {
                throw (Error)new InternalError().initCause(ex);
            }
        }
    }

    private static class PermissionInfo {
        final String type;
        final String name;
        final String actions;

        PermissionInfo(String type, String name, String actions) {
            this.type = type;
            this.name = name;
            this.actions = actions;
        }
    }
}

