/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.guice.conf.core.internal.injector;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.jmob.guice.conf.core.BindConfig;
import net.jmob.guice.conf.core.InjectConfig;
import net.jmob.guice.conf.core.internal.ConfigFactory;
import net.jmob.guice.conf.core.internal.injector.Injector;
import net.jmob.guice.conf.core.internal.virtual.VirtualBeanFactory;

@Singleton
public class InjectorBuilder {
    private final VirtualBeanFactory virtualBeanFactory;
    private final ConfigFactory configFactory;

    @Inject
    public InjectorBuilder(ConfigFactory configFactory, VirtualBeanFactory virtualBeanFactory) {
        this.configFactory = configFactory;
        this.virtualBeanFactory = virtualBeanFactory;
    }

    public Stream<Injector> build(Class beanClass) {
        Config config = this.getConfig(this.configFactory, this.getOptions(beanClass), this.getAnnotationConfiguration(beanClass));
        return Arrays.stream(beanClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(InjectConfig.class)).map(f -> this.virtualBeanFactory.withConfig(config).withPath(this.getAnnotationPath((Field)f)).withType(f.getType()).withField((Field)f)).map(Injector::new);
    }

    private Config getConfig(ConfigFactory configFactory, ConfigParseOptions parseOptions, BindConfig bindConfig) {
        Config config = configFactory.parseResources(bindConfig.value(), parseOptions);
        if (!bindConfig.path().isEmpty()) {
            config = config.getConfig(bindConfig.path());
        }
        if (bindConfig.resolve()) {
            config = config.resolve();
        }
        return config;
    }

    private String getAnnotationPath(Field f) {
        String annotationValue = ((InjectConfig[])f.getAnnotationsByType(InjectConfig.class))[0].value();
        return Strings.isNullOrEmpty((String)annotationValue) ? f.getName() : annotationValue;
    }

    private ConfigParseOptions getOptions(Class beanClass) {
        return ConfigParseOptions.defaults().setSyntax(ConfigSyntax.valueOf((String)this.getAnnotationConfiguration(beanClass).syntax().name()));
    }

    private BindConfig getAnnotationConfiguration(Class beanClass) {
        return (BindConfig)beanClass.getAnnotationsByType(BindConfig.class)[0];
    }
}

