/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.guice.conf.core.internal.virtual;

import com.google.inject.Singleton;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BeanValidator {
    private final Logger log = LoggerFactory.getLogger(BeanValidator.class);
    private final ValidatorFactory factory;

    public BeanValidator() {
        ValidatorFactory f = null;
        try {
            f = Validation.buildDefaultValidatorFactory();
            this.log.debug("Validation factory builder found");
        }
        catch (ValidationException e) {
            this.log.debug("No validation factory found in classpath");
        }
        finally {
            this.factory = f;
        }
    }

    public <T> T valid(T bean, Class beanInterface) {
        Set constraintsViolation;
        if (this.factory != null && !(constraintsViolation = this.factory.getValidator().validate(bean, new Class[0])).isEmpty()) {
            throw new RuntimeException(String.format("Constraint violation on %s : %s", beanInterface, ((ConstraintViolation)constraintsViolation.iterator().next()).getMessage()));
        }
        return bean;
    }
}

