/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.guice.conf.core.internal.virtual;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

final class VirtualBean
implements InvocationHandler {
    static final String GET_PREFIX = "get";
    private static final String HASH_CODE_METHOD = "hashCode";
    private static final String EQUALS_METHOD = "equals";
    private static final String TO_STRING_METHOD = "toString";
    private final Map<String, Object> values = new HashMap<String, Object>();

    public VirtualBean(Map<String, Object> values) {
        for (Map.Entry<String, Object> e : values == null ? this.values.entrySet() : values.entrySet()) {
            this.values.put(this.toGetMethodName(e.getKey()), e.getValue());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int nbArgs = this.nbArgs(args);
        if (methodName.startsWith(GET_PREFIX) && nbArgs == 0) {
            return this.magicGet(methodName, Optional.class.isAssignableFrom(method.getReturnType()));
        }
        if (methodName.equals(HASH_CODE_METHOD) && nbArgs == 0) {
            return this.hashCode();
        }
        if (methodName.equals(TO_STRING_METHOD) && nbArgs == 0) {
            return this.toString();
        }
        if (methodName.equals(EQUALS_METHOD) && nbArgs == 1) {
            return this.equals(args[0]);
        }
        throw new RuntimeException(String.format("Incorrect method name %s:%s", methodName, nbArgs));
    }

    private Object magicGet(String methodName, boolean optional) {
        return optional ? Optional.ofNullable(this.values.get(methodName)) : this.values.get(methodName);
    }

    private int nbArgs(Object[] args) {
        return args == null ? 0 : args.length;
    }

    private String toGetMethodName(String propertyName) {
        if (propertyName.length() <= 1) {
            return GET_PREFIX + propertyName.toUpperCase();
        }
        return GET_PREFIX + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (Proxy.isProxyClass(obj.getClass())) {
            return obj.equals(this);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualBean other = (VirtualBean)obj;
        return this.values.equals(other.values);
    }

    public int hashCode() {
        int prime = 47;
        return 47 + this.values.hashCode();
    }
}

