/*
 * Decompiled with CFR 0.152.
 */
package net.jmob.guice.conf.core.internal.virtual;

import com.google.inject.Singleton;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.jmob.guice.conf.core.internal.ConfigurationException;
import net.jmob.guice.conf.core.internal.Typed;
import net.jmob.guice.conf.core.internal.virtual.BeanValidator;
import net.jmob.guice.conf.core.internal.virtual.VirtualBean;

@Singleton
public class VirtualBeanFactory {
    private static final String GET_METHOD_PATTERN = "get.+";
    private static final int GET_PREFIX_SIZE = "get".length();
    private static final List<Class<?>> SUPPORTED_TYPES = Arrays.asList(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, String.class, Map.class, List.class);
    private final BeanValidator beanValidator;
    private Class<?> type;
    private boolean optionalType;
    private Config config;
    private String path;
    private Field field;

    @Inject
    public VirtualBeanFactory(BeanValidator beanValidator) {
        this.beanValidator = beanValidator;
    }

    public VirtualBeanFactory withConfig(Config config) {
        this.config = config;
        return this;
    }

    public VirtualBeanFactory withType(Class<?> type) {
        this.type = type;
        this.optionalType = Optional.class.isAssignableFrom(type);
        return this;
    }

    public VirtualBeanFactory withField(Field field) {
        this.field = field;
        return this;
    }

    public Field getField() {
        return this.field;
    }

    public Object buildValue() {
        return this.optionalType ? Optional.ofNullable(this.getValue()) : this.getValue();
    }

    private Object getValue() {
        if (this.optionalType && !this.config.hasPath(this.path)) {
            return null;
        }
        if (this.optionalType || SUPPORTED_TYPES.contains(this.type)) {
            return this.config.getAnyRef(this.path);
        }
        if (!this.type.isInterface()) {
            throw new ConfigurationException(String.format("Type not supported, must be a interface : %s", this.type));
        }
        return this.newProxyInstance(this.type, this.mapProperties(this.type, this.getProperties()));
    }

    private <T> T newProxyInstance(Class<T> beanInterface, Map<String, Object> values) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] interfaces = new Class[]{beanInterface};
        Object bean = Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)new VirtualBean(values));
        return (T)this.beanValidator.valid(bean, beanInterface);
    }

    private Map<String, Object> mapProperties(Class<?> beanInterface, Map<String, Object> values) {
        return values.entrySet().stream().map(e -> this.mapCandidateChild(beanInterface, (Map.Entry<String, Object>)e).orElse((Map.Entry<String, Object>)e)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Map.Entry<String, Object>> mapCandidateChild(Class<?> beanInterface, Map.Entry<String, Object> e) {
        if (e.getValue() instanceof Map) {
            return Arrays.stream(beanInterface.getMethods()).filter(method -> this.isCandidateMethod((String)e.getKey(), (Method)method)).map(method -> this.buildChildEntry((String)e.getKey(), (Method)method, (Map<String, Object>)((Map)e.getValue()))).findFirst();
        }
        return Optional.empty();
    }

    private boolean isCandidateMethod(String key, Method method) {
        return (method.getReturnType().isInterface() && !SUPPORTED_TYPES.contains(method.getReturnType()) || this.isAnnotationTypedPresent(method)) && method.getName().matches(GET_METHOD_PATTERN) && this.toPropertyName(method.getName()).equals(key);
    }

    private Map.Entry<String, Object> buildChildEntry(String key, Method m, Map<String, Object> values) {
        if (!this.isAnnotationTypedPresent(m)) {
            return new AbstractMap.SimpleImmutableEntry<String, Object>(this.buildChildEntry(m, key, values));
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, values.entrySet().stream().map(e -> this.buildChildEntry(m, (String)e.getKey(), (Map<String, Object>)((Map)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private Map.Entry<String, Map> buildChildEntry(Method m, String key, Map<String, Object> values) {
        return new AbstractMap.SimpleImmutableEntry<String, Map>(key, (Map)this.newProxyInstance(this.getType(m), values));
    }

    private Class<?> getType(Method m) {
        return this.isAnnotationTypedPresent(m) ? ((Typed[])m.getAnnotationsByType(Typed.class))[0].value() : m.getReturnType();
    }

    private boolean isAnnotationTypedPresent(Method m) {
        return m.isAnnotationPresent(Typed.class);
    }

    private String toPropertyName(String methodName) {
        return methodName.substring(GET_PREFIX_SIZE).substring(0, 1).toLowerCase().concat(methodName.substring(GET_PREFIX_SIZE + 1));
    }

    private Map<String, Object> getProperties() {
        return Optional.ofNullable(this.getRawProperties()).map(p -> p.stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigValue)e.getValue()).unwrapped()))).orElse(Collections.emptyMap());
    }

    private Set<Map.Entry<String, ConfigValue>> getRawProperties() {
        return Optional.ofNullable(this.config.getConfig(this.path)).map(c -> c.root().entrySet()).orElse(Collections.emptySet());
    }

    public VirtualBeanFactory withPath(String path) {
        this.path = path;
        return this;
    }
}

