/*
 * Decompiled with CFR 0.152.
 */
package net.joala.time;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class TimeFormat {
    @VisibleForTesting
    static final int TIMEUNIT_LIMIT = 2;

    private TimeFormat() {
    }

    public static String format(@Nonnegative long amount, @Nonnull TimeUnit timeUnit) {
        List reverse = Lists.reverse(Arrays.asList(TimeUnit.values()));
        for (TimeUnit currentUnit : reverse) {
            if (!currentUnit.equals((Object)timeUnit) && currentUnit.convert(amount, timeUnit) < 2L) continue;
            return TimeUnitFormat.getFormat(currentUnit).format(amount, timeUnit);
        }
        throw new IllegalArgumentException(String.format("TimeUnit %s not supported for formatting.", new Object[]{timeUnit}));
    }

    private static enum TimeUnitFormat {
        NANOSECONDS("ns", TimeUnit.NANOSECONDS),
        MICROSECONDS("\u00b5s", TimeUnit.MICROSECONDS),
        MILLISECONDS("ms", TimeUnit.MILLISECONDS),
        SECONDS("s", TimeUnit.SECONDS),
        MINUTES("min", TimeUnit.MINUTES),
        HOURS("h", TimeUnit.HOURS),
        DAYS("d", TimeUnit.DAYS);

        private final String sign;
        private final TimeUnit timeUnit;

        private TimeUnitFormat(String sign, TimeUnit timeUnit) {
            this.sign = sign;
            this.timeUnit = timeUnit;
        }

        public String format(long amount, TimeUnit sourceUnit) {
            return String.format("%d %s", this.timeUnit.convert(amount, sourceUnit), this.sign);
        }

        public static TimeUnitFormat getFormat(TimeUnit timeUnit) {
            return TimeUnitFormat.valueOf(timeUnit.name());
        }
    }
}

