/*
 * Decompiled with CFR 0.152.
 */
package net.joala.time;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.joala.time.Timeout;

public class TimeoutImpl
implements Timeout {
    private final long amount;
    private final TimeUnit unit;

    public TimeoutImpl(@Nonnegative long amount, @Nonnull TimeUnit unit) {
        Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (String)"amount must be positive: %s", (long)amount);
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"time unit must not be null");
        this.amount = amount;
        this.unit = unit;
    }

    @Override
    @Nonnegative
    public long in(@Nonnull TimeUnit targetUnit) {
        Preconditions.checkNotNull((Object)((Object)targetUnit), (Object)"time unit must not be null");
        return targetUnit.convert(this.amount, this.unit);
    }

    @Override
    @Nonnegative
    public long in(@Nonnull TimeUnit targetUnit, @Nonnegative double factor) {
        Preconditions.checkArgument((Double.compare(factor, 0.0) >= 0 ? 1 : 0) != 0, (String)"factor must be positive: %s", (Object)factor);
        return Math.round((double)this.in(targetUnit) * factor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("amount", this.amount).add("unit", (Object)this.unit).toString();
    }
}

