/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.concurrentunit;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class Waiter {
    private static final String TIMEOUT_MESSAGE = "Test timed out while waiting for an expected result";
    private final Thread mainThread;
    private AtomicInteger remainingResumes = new AtomicInteger(0);
    private volatile Throwable failure;

    public Waiter() {
        this.mainThread = Thread.currentThread();
    }

    public void assertEquals(Object actual, Object expected) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.fail(this.format(expected, actual));
    }

    public void assertFalse(boolean condition) {
        if (condition) {
            this.fail("expected false");
        }
    }

    public void assertNotNull(Object object) {
        if (object == null) {
            this.fail("expected not null");
        }
    }

    public void assertNull(Object object) {
        if (object != null) {
            this.fail(this.format("null", object));
        }
    }

    public void assertTrue(boolean condition) {
        if (!condition) {
            this.fail("expected true");
        }
    }

    public void await() throws Throwable {
        this.await(0L, 1);
    }

    public void await(long waitDuration) throws Throwable {
        this.await(waitDuration, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long waitDuration, int expectedResumes) throws Throwable {
        if (Thread.currentThread() != this.mainThread) {
            throw new IllegalStateException("Must be called from within the main test thread");
        }
        this.remainingResumes.compareAndSet(0, expectedResumes);
        Waiter waiter = this;
        synchronized (waiter) {
            try {
                if (waitDuration < 0L) {
                    this.wait();
                } else {
                    this.wait(waitDuration);
                }
                throw new TimeoutException(TIMEOUT_MESSAGE);
            }
            catch (InterruptedException e) {
                if (this.failure != null) {
                    Throwable f = this.failure;
                    this.failure = null;
                    throw f;
                }
            }
        }
    }

    public void expectResume() {
        this.remainingResumes.addAndGet(1);
    }

    public void expectResumes(int resumeNumber) {
        this.remainingResumes.addAndGet(resumeNumber);
    }

    public void fail() {
        this.fail((Throwable)((Object)new AssertionError()));
    }

    public void fail(String reason) {
        this.fail((Throwable)((Object)new AssertionError((Object)reason)));
    }

    public void fail(Throwable reason) {
        if (Thread.currentThread() == this.mainThread) {
            AssertionError ae = null;
            if (reason instanceof AssertionError) {
                ae = (AssertionError)((Object)reason);
            } else {
                ae = new AssertionError();
                ((Throwable)((Object)ae)).initCause(reason);
            }
            throw ae;
        }
        this.failure = reason;
        this.mainThread.interrupt();
    }

    public int getExpectedResumes() {
        return this.remainingResumes.get();
    }

    public void resume() {
        this.resume(this.mainThread);
    }

    public void resume(Thread thread) {
        if (thread != this.mainThread) {
            thread.interrupt();
        } else {
            int expectedResumes = this.remainingResumes.decrementAndGet();
            if (expectedResumes < 0) {
                throw new IllegalStateException("The waiter is not expecting resume to be called");
            }
            if (expectedResumes == 0) {
                thread.interrupt();
            }
        }
    }

    public void sleep(long sleepDuration) throws Throwable {
        this.sleep(sleepDuration, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long sleepDuration, int expectedResumes) throws Throwable {
        if (Thread.currentThread() != this.mainThread) {
            throw new IllegalStateException("Must be called from within the main test thread");
        }
        this.remainingResumes.compareAndSet(0, expectedResumes);
        try {
            try {
                Thread.sleep(sleepDuration);
                throw new TimeoutException(TIMEOUT_MESSAGE);
            }
            catch (InterruptedException ignored) {
                if (this.failure != null) {
                    Throwable f = this.failure;
                    this.failure = null;
                    throw f;
                }
            }
        }
        catch (Throwable throwable) {
            if (this.failure != null) {
                Throwable f = this.failure;
                this.failure = null;
                throw f;
            }
            throw throwable;
        }
    }

    private String format(Object expected, Object actual) {
        return "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

