/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.concurrentunit;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.jodah.concurrentunit.internal.ReentrantCircuit;

public class Waiter {
    private static final String TIMEOUT_MESSAGE = "Test timed out while waiting for an expected result";
    private final Thread mainThread;
    private AtomicInteger remainingResumes = new AtomicInteger(0);
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private volatile Throwable failure;

    public Waiter() {
        this.mainThread = Thread.currentThread();
        this.circuit.open();
    }

    public void assertEquals(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        this.fail(this.format(expected, actual));
    }

    public void assertFalse(boolean condition) {
        if (condition) {
            this.fail("expected false");
        }
    }

    public void assertNotNull(Object object) {
        if (object == null) {
            this.fail("expected not null");
        }
    }

    public void assertNull(Object object) {
        if (object != null) {
            this.fail(this.format("null", object));
        }
    }

    public void assertTrue(boolean condition) {
        if (!condition) {
            this.fail("expected true");
        }
    }

    public void await() throws Throwable {
        this.await(0L, TimeUnit.MILLISECONDS, 1);
    }

    public void await(long delay) throws Throwable {
        this.await(delay, TimeUnit.MILLISECONDS, 1);
    }

    public void await(long delay, TimeUnit timeUnit) throws Throwable {
        this.await(delay, timeUnit, 1);
    }

    public void await(long delay, int expectedResumes) throws Throwable {
        this.await(delay, TimeUnit.MILLISECONDS, expectedResumes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long delay, TimeUnit timeUnit, int expectedResumes) throws Throwable {
        block15: {
            if (Thread.currentThread() != this.mainThread) {
                throw new IllegalStateException("Must be called from within the main test thread");
            }
            try {
                if (this.failure != null) break block15;
                Waiter waiter = this;
                synchronized (waiter) {
                    int remaining = this.remainingResumes.addAndGet(expectedResumes);
                    if (remaining > 0) {
                        this.circuit.open();
                    }
                }
                if (delay == 0L) {
                    this.circuit.await();
                } else if (!this.circuit.await(delay, timeUnit)) {
                    throw new TimeoutException(TIMEOUT_MESSAGE);
                }
            }
            catch (InterruptedException e) {
                this.remainingResumes.set(0);
                this.circuit.open();
                if (this.failure != null) {
                    Throwable f = this.failure;
                    this.failure = null;
                    throw f;
                }
            }
            finally {
                this.remainingResumes.set(0);
                this.circuit.open();
                if (this.failure != null) {
                    Throwable f = this.failure;
                    this.failure = null;
                    throw f;
                }
            }
        }
    }

    public synchronized void resume() {
        if (this.remainingResumes.decrementAndGet() <= 0) {
            this.circuit.close();
        }
    }

    public void fail() {
        this.fail((Throwable)((Object)new AssertionError()));
    }

    public void fail(String reason) {
        this.fail((Throwable)((Object)new AssertionError((Object)reason)));
    }

    public void fail(Throwable reason) {
        AssertionError ae = null;
        if (reason instanceof AssertionError) {
            ae = (AssertionError)((Object)reason);
        } else {
            ae = new AssertionError();
            ((Throwable)((Object)ae)).initCause(reason);
        }
        this.failure = reason;
        this.circuit.close();
        throw ae;
    }

    private String format(Object expected, Object actual) {
        return "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

