/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.expiringmap;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jodah.expiringmap.NamedThreadFactory;

public class ExpiringMap<K, V>
implements ConcurrentMap<K, V> {
    static final Timer timer = new Timer("ExpiringMap", true);
    static final ThreadPoolExecutor listenerService = NamedThreadFactory.decorate((ThreadPoolExecutor)Executors.newCachedThreadPool(), "ExpiringMap");
    private static final long LISTENER_EXECUTION_THRESHOLD = 100L;
    List<ExpirationListenerConfig<K, V>> expirationListeners;
    private AtomicLong expirationMillis;
    private final AtomicReference<ExpirationPolicy> expirationPolicy;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final EntryMap<K, V> entries;
    private final boolean variableExpiration;

    private ExpiringMap(Builder builder) {
        this.variableExpiration = builder.variableExpiration;
        this.entries = (EntryMap)((Object)(this.variableExpiration ? new EntryTreeHashMap() : new EntryLinkedHashMap()));
        if (builder.expirationListeners != null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListenerConfig<K, V>>(builder.expirationListeners);
        }
        this.expirationPolicy = new AtomicReference<ExpirationPolicy>(builder.expirationPolicy);
        this.expirationMillis = new AtomicLong(TimeUnit.MILLISECONDS.convert(builder.duration, builder.timeUnit));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <K, V> ExpiringMap<K, V> create() {
        return new ExpiringMap<K, V>(ExpiringMap.builder());
    }

    public void addExpirationListener(ExpirationListener<K, V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.expirationListeners == null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListenerConfig<K, V>>();
        }
        this.expirationListeners.add(new ExpirationListenerConfig<K, V>(listener));
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            for (ExpiringEntry entry : this.entries.values()) {
                entry.cancel(false);
            }
            this.entries.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry == null) {
            return null;
        }
        if (ExpirationPolicy.ACCESSED.equals((Object)entry.expirationPolicy.get())) {
            this.resetEntry(entry, false);
        }
        return entry.getValue();
    }

    public long getExpiration() {
        return this.expirationMillis.get();
    }

    public long getExpiration(K key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.expirationMillis.get();
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.entries.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.readLock.lock();
        try {
            Set set = this.entries.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.putInternal(key, value, this.expirationPolicy.get(), this.getExpiration());
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy) {
        return this.put(key, value, expirationPolicy, this.expirationMillis.get(), TimeUnit.MILLISECONDS);
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy, long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        if (key == null || timeUnit == null) {
            throw new NullPointerException();
        }
        return this.putInternal(key, value, expirationPolicy, TimeUnit.MILLISECONDS.convert(duration, timeUnit));
    }

    public V put(K key, V value, long duration, TimeUnit timeUnit) {
        return this.put(key, value, this.expirationPolicy.get(), duration, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        long expiration = this.getExpiration();
        ExpirationPolicy expirationPolicy = this.expirationPolicy.get();
        this.writeLock.lock();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putInternal(entry.getKey(), entry.getValue(), expirationPolicy, expiration);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.writeLock.lock();
        try {
            if (!this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.getExpiration());
                return v;
            }
            Object v = ((ExpiringEntry)this.entries.get(key)).getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        ExpiringEntry entry = null;
        this.writeLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        if (entry == null) {
            return null;
        }
        if (entry.cancel(false)) {
            this.scheduleEntry(this.entries.first());
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(value)) {
                this.entries.remove(key);
                if (entry.cancel(false)) {
                    this.scheduleEntry(this.entries.first());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.writeLock.lock();
        try {
            if (this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.getExpiration());
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(oldValue)) {
                this.putInternal(key, newValue, this.expirationPolicy.get(), this.getExpiration());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeExpirationListener(ExpirationListener<K, V> listener) {
        for (int i = 0; i < this.expirationListeners.size(); ++i) {
            if (!this.expirationListeners.get((int)i).expirationListener.equals(listener)) continue;
            this.expirationListeners.remove(i);
            return;
        }
    }

    public void resetExpiration(K key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry != null) {
            this.resetEntry(entry, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(K key, long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            entry.expirationMillis.set(TimeUnit.MILLISECONDS.convert(duration, timeUnit));
            this.resetEntry(entry, true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setExpiration(long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        this.expirationMillis.set(TimeUnit.MILLISECONDS.convert(duration, timeUnit));
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy.set(expirationPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpirationPolicy(K key, ExpirationPolicy expirationPolicy) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry != null) {
            entry.expirationPolicy.set(expirationPolicy);
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Iterator<V> valuesIterator() {
        return new Iterator<V>(){
            private final Iterator<ExpiringEntry<K, V>> iterator;
            {
                this.iterator = ExpiringMap.this.entries.valuesIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    void notifyListeners(final ExpiringEntry<K, V> entry) {
        if (this.expirationListeners == null) {
            return;
        }
        for (final ExpirationListenerConfig<K, V> listener : this.expirationListeners) {
            if (listener.executionPolicy == 0) {
                listener.expirationListener.expired(entry.key, entry.getValue());
                continue;
            }
            if (listener.executionPolicy == 1) {
                listenerService.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.expirationListener.expired(entry.key, entry.getValue());
                    }
                });
                continue;
            }
            long startTime = System.currentTimeMillis();
            listener.expirationListener.expired(entry.key, entry.getValue());
            long endTime = System.currentTimeMillis();
            listener.executionPolicy = startTime + 100L > endTime ? 0 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V putInternal(K key, V value, ExpirationPolicy expirationPolicy, long expirationMillis) {
        this.writeLock.lock();
        try {
            ExpiringEntry<K, V> entry = (ExpiringEntry<K, V>)this.entries.get(key);
            Object oldValue = null;
            if (entry == null) {
                entry = new ExpiringEntry<K, V>(key, value, this.variableExpiration ? new AtomicReference<ExpirationPolicy>(expirationPolicy) : this.expirationPolicy, this.variableExpiration ? new AtomicLong(expirationMillis) : this.expirationMillis);
                this.entries.put(key, entry);
                if (this.entries.size() == 1 || this.entries.first().equals(entry)) {
                    this.scheduleEntry(entry);
                }
            } else {
                oldValue = entry.getValue();
                if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
                    V v = value;
                    return v;
                }
                entry.setValue(value);
                this.resetEntry(entry, false);
            }
            Object object = oldValue;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEntry(ExpiringEntry<K, V> entry, boolean scheduleFirstEntry) {
        this.writeLock.lock();
        try {
            boolean scheduled = entry.cancel(true);
            this.entries.reorder(entry);
            if (scheduled || scheduleFirstEntry) {
                this.scheduleEntry(this.entries.first());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEntry(ExpiringEntry<K, V> entry) {
        if (entry == null || entry.scheduled) {
            return;
        }
        TimerTask timerTask = null;
        ExpiringEntry<K, V> expiringEntry = entry;
        synchronized (expiringEntry) {
            if (entry.scheduled) {
                return;
            }
            final WeakReference<ExpiringEntry<K, V>> entryReference = new WeakReference<ExpiringEntry<K, V>>(entry);
            timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExpiringEntry entry = (ExpiringEntry)entryReference.get();
                    ExpiringMap.this.writeLock.lock();
                    try {
                        if (entry != null && entry.scheduled) {
                            ExpiringMap.this.entries.remove(entry.key);
                            ExpiringMap.this.notifyListeners(entry);
                        }
                        try {
                            Iterator iterator = ExpiringMap.this.entries.valuesIterator();
                            boolean schedulePending = true;
                            while (iterator.hasNext() && schedulePending) {
                                ExpiringEntry nextEntry = iterator.next();
                                if (nextEntry.expiration.get().getTime() <= System.currentTimeMillis()) {
                                    iterator.remove();
                                    ExpiringMap.this.notifyListeners(nextEntry);
                                    continue;
                                }
                                ExpiringMap.this.scheduleEntry(nextEntry);
                                schedulePending = false;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ExpiringMap.this.writeLock.unlock();
                    }
                }
            };
            entry.schedule(timerTask);
        }
        timer.schedule(timerTask, entry.expiration.get());
    }

    static class ExpiringEntry<K, V>
    implements Comparable<ExpiringEntry<K, V>> {
        final AtomicLong expirationMillis;
        final AtomicReference<Date> expiration;
        final AtomicReference<ExpirationPolicy> expirationPolicy;
        final K key;
        volatile TimerTask timerTask;
        V value;
        volatile boolean scheduled;

        ExpiringEntry(K key, V value, AtomicReference<ExpirationPolicy> expirationPolicy, AtomicLong expirationMillis) {
            this.key = key;
            this.value = value;
            this.expirationPolicy = expirationPolicy;
            this.expirationMillis = expirationMillis;
            this.expiration = new AtomicReference();
            this.resetExpiration();
        }

        @Override
        public int compareTo(ExpiringEntry<K, V> pOther) {
            if (this.key.equals(pOther.key)) {
                return 0;
            }
            int result = this.expiration.get().compareTo(pOther.expiration.get());
            return result == 0 ? 1 : result;
        }

        public boolean equals(Object pOther) {
            return this.key.equals(((ExpiringEntry)pOther).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        synchronized boolean cancel(boolean resetExpiration) {
            boolean result = this.scheduled;
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.timerTask = null;
            this.scheduled = false;
            if (resetExpiration) {
                this.resetExpiration();
            }
            return result;
        }

        synchronized V getValue() {
            return this.value;
        }

        void resetExpiration() {
            this.expiration.set(new Date(this.expirationMillis.get() + System.currentTimeMillis()));
        }

        synchronized void schedule(TimerTask timerTask) {
            this.timerTask = timerTask;
            this.scheduled = true;
        }

        synchronized void setValue(V value) {
            this.value = value;
        }
    }

    static class ExpirationListenerConfig<K, V> {
        final ExpirationListener<K, V> expirationListener;
        int executionPolicy = -1;

        ExpirationListenerConfig(ExpirationListener<K, V> expirationListener) {
            this.expirationListener = expirationListener;
        }
    }

    static class EntryTreeHashMap<K, V>
    extends HashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;
        SortedSet<ExpiringEntry<K, V>> sortedSet = new TreeSet<ExpiringEntry<K, V>>();

        EntryTreeHashMap() {
        }

        @Override
        public void clear() {
            super.clear();
            this.sortedSet.clear();
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.sortedSet.isEmpty() ? null : this.sortedSet.first();
        }

        @Override
        public ExpiringEntry<K, V> put(K key, ExpiringEntry<K, V> value) {
            this.sortedSet.add(value);
            return super.put(key, value);
        }

        @Override
        public ExpiringEntry<K, V> remove(Object key) {
            ExpiringEntry entry = (ExpiringEntry)super.remove(key);
            if (entry != null) {
                this.sortedSet.remove(entry);
            }
            return entry;
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.sortedSet.remove(value);
            this.sortedSet.add(value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return new Iterator<ExpiringEntry<K, V>>(){
                private final Iterator<ExpiringEntry<K, V>> iterator;
                private ExpiringEntry<K, V> next;
                {
                    this.iterator = EntryTreeHashMap.this.sortedSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public ExpiringEntry<K, V> next() {
                    this.next = this.iterator.next();
                    return this.next;
                }

                @Override
                public void remove() {
                    EntryTreeHashMap.super.remove(this.next.key);
                    this.iterator.remove();
                }
            };
        }
    }

    static interface EntryMap<K, V>
    extends Map<K, ExpiringEntry<K, V>> {
        public ExpiringEntry<K, V> first();

        public void reorder(ExpiringEntry<K, V> var1);

        public Iterator<ExpiringEntry<K, V>> valuesIterator();
    }

    static class EntryLinkedHashMap<K, V>
    extends LinkedHashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;

        EntryLinkedHashMap() {
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.isEmpty() ? null : (ExpiringEntry)this.values().iterator().next();
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.remove(value.key);
            this.put(value.key, value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return this.values().iterator();
        }
    }

    public static enum ExpirationPolicy {
        ACCESSED,
        CREATED;

    }

    public static interface ExpirationListener<K, V> {
        public void expired(K var1, V var2);
    }

    public static final class Builder {
        private ExpirationPolicy expirationPolicy = ExpirationPolicy.CREATED;
        private List<ExpirationListenerConfig<?, ?>> expirationListeners;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private boolean variableExpiration;
        private long duration = 60L;

        private Builder() {
        }

        public <K, V> ExpiringMap<K, V> build() {
            return new ExpiringMap(this);
        }

        public Builder expiration(long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder expirationListener(ExpirationListener<?, ?> ... listeners) {
            if (this.expirationListeners == null) {
                this.expirationListeners = new ArrayList(listeners.length);
            }
            for (ExpirationListener<?, ?> listener : listeners) {
                this.expirationListeners.add(new ExpirationListenerConfig(listener));
            }
            return this;
        }

        public Builder expirationPolicy(ExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        public Builder variableExpiration() {
            this.variableExpiration = true;
            return this;
        }
    }
}

