/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.expiringmap;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jodah.expiringmap.NamedThreadFactory;

public class ExpiringMap<K, V>
implements ConcurrentMap<K, V> {
    static final ScheduledExecutorService expirer = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("ExpiringMap-Expirer"));
    static final ThreadPoolExecutor listenerService = (ThreadPoolExecutor)Executors.newCachedThreadPool(new NamedThreadFactory("ExpiringMap-Listener-%s"));
    private static final long LISTENER_EXECUTION_THRESHOLD = TimeUnit.MILLISECONDS.toNanos(100L);
    List<ExpirationListenerConfig<K, V>> expirationListeners;
    private AtomicLong expirationNanos;
    private final AtomicReference<ExpirationPolicy> expirationPolicy;
    private final EntryLoader<? super K, ? extends V> entryLoader;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final EntryMap<K, V> entries;
    private final boolean variableExpiration;

    private ExpiringMap(Builder<K, V> builder) {
        this.variableExpiration = ((Builder)builder).variableExpiration;
        this.entries = (EntryMap)((Object)(this.variableExpiration ? new EntryTreeHashMap() : new EntryLinkedHashMap()));
        if (((Builder)builder).expirationListeners != null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListenerConfig<K, V>>(((Builder)builder).expirationListeners);
        }
        this.expirationPolicy = new AtomicReference<ExpirationPolicy>(((Builder)builder).expirationPolicy);
        this.expirationNanos = new AtomicLong(TimeUnit.NANOSECONDS.convert(((Builder)builder).duration, ((Builder)builder).timeUnit));
        this.entryLoader = ((Builder)builder).entryLoader;
    }

    public static Builder<Object, Object> builder() {
        return new Builder<Object, Object>();
    }

    public static <K, V> ExpiringMap<K, V> create() {
        return new ExpiringMap<Object, Object>(ExpiringMap.builder());
    }

    public void addExpirationListener(ExpirationListener<K, V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.expirationListeners == null) {
            this.expirationListeners = new CopyOnWriteArrayList<ExpirationListenerConfig<K, V>>();
        }
        this.expirationListeners.add(new ExpirationListenerConfig<K, V>(listener));
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            for (ExpiringEntry entry : this.entries.values()) {
                entry.cancel(false);
            }
            this.entries.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object entry) {
                if (!(entry instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)entry;
                return ExpiringMap.this.containsKey(e.getKey());
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.EntryIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.EntryIterator();
            }

            @Override
            public boolean remove(Object entry) {
                if (entry instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)entry;
                    return ExpiringMap.this.remove(e.getKey()) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        this.readLock.lock();
        try {
            boolean bl = this.entries.equals(obj);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry == null) {
            if (this.entryLoader == null) {
                return null;
            }
            Object typedKey = key;
            V value = this.entryLoader.load(typedKey);
            this.put(typedKey, value);
            return value;
        }
        if (ExpirationPolicy.ACCESSED.equals((Object)entry.expirationPolicy.get())) {
            this.resetEntry(entry, false);
        }
        return entry.getValue();
    }

    public long getExpiration() {
        return TimeUnit.NANOSECONDS.toMillis(this.expirationNanos.get());
    }

    public long getExpiration(K key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return TimeUnit.NANOSECONDS.toMillis(entry.expirationNanos.get());
    }

    public long getExpectedExpiration(K key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return TimeUnit.NANOSECONDS.toMillis(entry.expectedExpiration.get() - System.nanoTime());
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.entries.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.entries.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object key) {
                return ExpiringMap.this.containsKey(key);
            }

            @Override
            public Iterator<K> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.KeyIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.KeyIterator();
            }

            @Override
            public boolean remove(Object value) {
                return ExpiringMap.this.remove(value) != null;
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy) {
        return this.put(key, value, expirationPolicy, this.expirationNanos.get(), TimeUnit.NANOSECONDS);
    }

    public V put(K key, V value, ExpirationPolicy expirationPolicy, long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        if (key == null || timeUnit == null) {
            throw new NullPointerException();
        }
        return this.putInternal(key, value, expirationPolicy, TimeUnit.NANOSECONDS.convert(duration, timeUnit));
    }

    public V put(K key, V value, long duration, TimeUnit timeUnit) {
        return this.put(key, value, this.expirationPolicy.get(), duration, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        long expiration = this.expirationNanos.get();
        ExpirationPolicy expirationPolicy = this.expirationPolicy.get();
        this.writeLock.lock();
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putInternal(entry.getKey(), entry.getValue(), expirationPolicy, expiration);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.writeLock.lock();
        try {
            if (!this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
                return v;
            }
            Object v = ((ExpiringEntry)this.entries.get(key)).getValue();
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        ExpiringEntry entry = null;
        this.writeLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.remove(key);
        }
        finally {
            this.writeLock.unlock();
        }
        if (entry == null) {
            return null;
        }
        if (entry.cancel(false)) {
            this.scheduleEntry(this.entries.first());
        }
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(value)) {
                this.entries.remove(key);
                if (entry.cancel(false)) {
                    this.scheduleEntry(this.entries.first());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.writeLock.lock();
        try {
            if (this.entries.containsKey(key)) {
                V v = this.putInternal(key, value, this.expirationPolicy.get(), this.expirationNanos.get());
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            if (entry != null && entry.getValue().equals(oldValue)) {
                this.putInternal(key, newValue, this.expirationPolicy.get(), this.expirationNanos.get());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeExpirationListener(ExpirationListener<K, V> listener) {
        for (int i = 0; i < this.expirationListeners.size(); ++i) {
            if (!this.expirationListeners.get((int)i).expirationListener.equals(listener)) continue;
            this.expirationListeners.remove(i);
            return;
        }
    }

    public void resetExpiration(K key) {
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry != null) {
            this.resetEntry(entry, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpiration(K key, long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        this.writeLock.lock();
        try {
            ExpiringEntry entry = (ExpiringEntry)this.entries.get(key);
            entry.expirationNanos.set(TimeUnit.NANOSECONDS.convert(duration, timeUnit));
            this.resetEntry(entry, true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setExpiration(long duration, TimeUnit timeUnit) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        this.expirationNanos.set(TimeUnit.NANOSECONDS.convert(duration, timeUnit));
    }

    public void setExpirationPolicy(ExpirationPolicy expirationPolicy) {
        this.expirationPolicy.set(expirationPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpirationPolicy(K key, ExpirationPolicy expirationPolicy) {
        if (!this.variableExpiration) {
            throw new UnsupportedOperationException("Variable expiration is not enabled");
        }
        ExpiringEntry entry = null;
        this.readLock.lock();
        try {
            entry = (ExpiringEntry)this.entries.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (entry != null) {
            entry.expirationPolicy.set(expirationPolicy);
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = this.entries.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public void clear() {
                ExpiringMap.this.clear();
            }

            @Override
            public boolean contains(Object value) {
                return ExpiringMap.this.containsValue(value);
            }

            @Override
            public Iterator<V> iterator() {
                return ExpiringMap.this.entries instanceof EntryLinkedHashMap ? (EntryLinkedHashMap)ExpiringMap.this.entries.new EntryLinkedHashMap.ValueIterator() : (EntryTreeHashMap)ExpiringMap.this.entries.new EntryTreeHashMap.ValueIterator();
            }

            @Override
            public int size() {
                return ExpiringMap.this.size();
            }
        };
    }

    void notifyListeners(final ExpiringEntry<K, V> entry) {
        if (this.expirationListeners == null) {
            return;
        }
        for (final ExpirationListenerConfig<K, V> listener : this.expirationListeners) {
            if (listener.executionPolicy == 0) {
                listener.expirationListener.expired(entry.key, entry.getValue());
                continue;
            }
            if (listener.executionPolicy == 1) {
                listenerService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            listener.expirationListener.expired(entry.key, entry.getValue());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                continue;
            }
            long startTime = System.nanoTime();
            try {
                listener.expirationListener.expired(entry.key, entry.getValue());
            }
            catch (Exception ignoreUserExceptions) {
                // empty catch block
            }
            long endTime = System.nanoTime();
            listener.executionPolicy = startTime + LISTENER_EXECUTION_THRESHOLD > endTime ? 0 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V putInternal(K key, V value, ExpirationPolicy expirationPolicy, long expirationNanos) {
        this.writeLock.lock();
        try {
            ExpiringEntry<K, V> entry = (ExpiringEntry<K, V>)this.entries.get(key);
            Object oldValue = null;
            if (entry == null) {
                entry = new ExpiringEntry<K, V>(key, value, this.variableExpiration ? new AtomicReference<ExpirationPolicy>(expirationPolicy) : this.expirationPolicy, this.variableExpiration ? new AtomicLong(expirationNanos) : this.expirationNanos);
                this.entries.put(key, entry);
                if (this.entries.size() == 1 || this.entries.first().equals(entry)) {
                    this.scheduleEntry(entry);
                }
            } else {
                oldValue = entry.getValue();
                if (!ExpirationPolicy.ACCESSED.equals((Object)expirationPolicy) && (oldValue == null && value == null || oldValue != null && oldValue.equals(value))) {
                    V v = value;
                    return v;
                }
                entry.setValue(value);
                this.resetEntry(entry, false);
            }
            Object object = oldValue;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEntry(ExpiringEntry<K, V> entry, boolean scheduleFirstEntry) {
        this.writeLock.lock();
        try {
            boolean scheduled = entry.cancel(true);
            this.entries.reorder(entry);
            if (scheduled || scheduleFirstEntry) {
                this.scheduleEntry(this.entries.first());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleEntry(ExpiringEntry<K, V> entry) {
        if (entry == null || entry.scheduled) {
            return;
        }
        Runnable runnable = null;
        ExpiringEntry<K, V> expiringEntry = entry;
        synchronized (expiringEntry) {
            if (entry.scheduled) {
                return;
            }
            final WeakReference<ExpiringEntry<K, V>> entryReference = new WeakReference<ExpiringEntry<K, V>>(entry);
            runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ExpiringEntry entry = (ExpiringEntry)entryReference.get();
                    ExpiringMap.this.writeLock.lock();
                    try {
                        if (entry != null && entry.scheduled) {
                            ExpiringMap.this.entries.remove(entry.key);
                            ExpiringMap.this.notifyListeners(entry);
                        }
                        try {
                            Iterator iterator = ExpiringMap.this.entries.valuesIterator();
                            boolean schedulePending = true;
                            while (iterator.hasNext() && schedulePending) {
                                ExpiringEntry nextEntry = iterator.next();
                                if (nextEntry.expectedExpiration.get() <= System.nanoTime()) {
                                    iterator.remove();
                                    ExpiringMap.this.notifyListeners(nextEntry);
                                    continue;
                                }
                                ExpiringMap.this.scheduleEntry(nextEntry);
                                schedulePending = false;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    finally {
                        ExpiringMap.this.writeLock.unlock();
                    }
                }
            };
            ScheduledFuture<?> entryFuture = expirer.schedule(runnable, entry.expectedExpiration.get() - System.nanoTime(), TimeUnit.NANOSECONDS);
            entry.schedule(entryFuture);
        }
    }

    private static <K, V> Map.Entry<K, V> mapEntryFor(final ExpiringEntry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.key;
            }

            @Override
            public V getValue() {
                return entry.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static class ExpiringEntry<K, V>
    implements Comparable<ExpiringEntry<K, V>> {
        final AtomicLong expirationNanos;
        final AtomicLong expectedExpiration;
        final AtomicReference<ExpirationPolicy> expirationPolicy;
        final K key;
        volatile Future<?> entryFuture;
        V value;
        volatile boolean scheduled;

        ExpiringEntry(K key, V value, AtomicReference<ExpirationPolicy> expirationPolicy, AtomicLong expirationNanos) {
            this.key = key;
            this.value = value;
            this.expirationPolicy = expirationPolicy;
            this.expirationNanos = expirationNanos;
            this.expectedExpiration = new AtomicLong();
            this.resetExpiration();
        }

        @Override
        public int compareTo(ExpiringEntry<K, V> other) {
            if (this.key.equals(other.key)) {
                return 0;
            }
            return this.expectedExpiration.get() < other.expectedExpiration.get() ? -1 : 1;
        }

        public boolean equals(Object pOther) {
            return this.key.equals(((ExpiringEntry)pOther).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }

        synchronized boolean cancel(boolean resetExpiration) {
            boolean result = this.scheduled;
            if (this.entryFuture != null) {
                this.entryFuture.cancel(false);
            }
            this.entryFuture = null;
            this.scheduled = false;
            if (resetExpiration) {
                this.resetExpiration();
            }
            return result;
        }

        synchronized V getValue() {
            return this.value;
        }

        void resetExpiration() {
            this.expectedExpiration.set(this.expirationNanos.get() + System.nanoTime());
        }

        synchronized void schedule(Future<?> entryFuture) {
            this.entryFuture = entryFuture;
            this.scheduled = true;
        }

        synchronized void setValue(V value) {
            this.value = value;
        }
    }

    static class ExpirationListenerConfig<K, V> {
        final ExpirationListener<K, V> expirationListener;
        int executionPolicy = -1;

        ExpirationListenerConfig(ExpirationListener<K, V> expirationListener) {
            this.expirationListener = expirationListener;
        }
    }

    static class EntryTreeHashMap<K, V>
    extends HashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;
        SortedSet<ExpiringEntry<K, V>> sortedSet = new TreeSet<ExpiringEntry<K, V>>();

        EntryTreeHashMap() {
        }

        @Override
        public void clear() {
            super.clear();
            this.sortedSet.clear();
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.sortedSet.isEmpty() ? null : this.sortedSet.first();
        }

        @Override
        public ExpiringEntry<K, V> put(K key, ExpiringEntry<K, V> value) {
            this.sortedSet.add(value);
            return super.put(key, value);
        }

        @Override
        public ExpiringEntry<K, V> remove(Object key) {
            ExpiringEntry entry = (ExpiringEntry)super.remove(key);
            if (entry != null) {
                this.sortedSet.remove(entry);
            }
            return entry;
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.sortedSet.remove(value);
            this.sortedSet.add(value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return new ExpiringEntryIterator();
        }

        final class EntryIterator
        extends AbstractHashIterator
        implements Iterator<Map.Entry<K, V>> {
            EntryIterator() {
            }

            @Override
            public final Map.Entry<K, V> next() {
                return ExpiringMap.mapEntryFor(this.getNext());
            }
        }

        final class ValueIterator
        extends AbstractHashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public final V next() {
                return this.getNext().value;
            }
        }

        final class KeyIterator
        extends AbstractHashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public final K next() {
                return this.getNext().key;
            }
        }

        final class ExpiringEntryIterator
        extends AbstractHashIterator
        implements Iterator<ExpiringEntry<K, V>> {
            ExpiringEntryIterator() {
            }

            @Override
            public final ExpiringEntry<K, V> next() {
                return this.getNext();
            }
        }

        abstract class AbstractHashIterator {
            private final Iterator<ExpiringEntry<K, V>> iterator;
            protected ExpiringEntry<K, V> next;

            AbstractHashIterator() {
                this.iterator = EntryTreeHashMap.this.sortedSet.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public ExpiringEntry<K, V> getNext() {
                this.next = this.iterator.next();
                return this.next;
            }

            public void remove() {
                EntryTreeHashMap.super.remove(this.next.key);
                this.iterator.remove();
            }
        }
    }

    static class EntryLinkedHashMap<K, V>
    extends LinkedHashMap<K, ExpiringEntry<K, V>>
    implements EntryMap<K, V> {
        private static final long serialVersionUID = 1L;

        EntryLinkedHashMap() {
        }

        @Override
        public ExpiringEntry<K, V> first() {
            return this.isEmpty() ? null : (ExpiringEntry)this.values().iterator().next();
        }

        @Override
        public void reorder(ExpiringEntry<K, V> value) {
            this.remove(value.key);
            this.put(value.key, value);
        }

        @Override
        public Iterator<ExpiringEntry<K, V>> valuesIterator() {
            return this.values().iterator();
        }

        public final class EntryIterator
        extends AbstractHashIterator
        implements Iterator<Map.Entry<K, V>> {
            @Override
            public final Map.Entry<K, V> next() {
                return ExpiringMap.mapEntryFor(this.getNext());
            }
        }

        final class ValueIterator
        extends AbstractHashIterator
        implements Iterator<V> {
            ValueIterator() {
            }

            @Override
            public final V next() {
                return this.getNext().value;
            }
        }

        final class KeyIterator
        extends AbstractHashIterator
        implements Iterator<K> {
            KeyIterator() {
            }

            @Override
            public final K next() {
                return this.getNext().key;
            }
        }

        abstract class AbstractHashIterator {
            private final Iterator<Map.Entry<K, ExpiringEntry<K, V>>> iterator;
            private ExpiringEntry<K, V> next;

            AbstractHashIterator() {
                this.iterator = EntryLinkedHashMap.this.entrySet().iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public ExpiringEntry<K, V> getNext() {
                this.next = this.iterator.next().getValue();
                return this.next;
            }

            public void remove() {
                this.iterator.remove();
            }
        }
    }

    static interface EntryMap<K, V>
    extends Map<K, ExpiringEntry<K, V>> {
        public ExpiringEntry<K, V> first();

        public void reorder(ExpiringEntry<K, V> var1);

        public Iterator<ExpiringEntry<K, V>> valuesIterator();
    }

    public static enum ExpirationPolicy {
        ACCESSED,
        CREATED;

    }

    public static interface EntryLoader<K, V> {
        public V load(K var1);
    }

    public static interface ExpirationListener<K, V> {
        public void expired(K var1, V var2);
    }

    public static final class Builder<K, V> {
        private ExpirationPolicy expirationPolicy = ExpirationPolicy.CREATED;
        private List<ExpirationListenerConfig<K, V>> expirationListeners;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private boolean variableExpiration;
        private long duration = 60L;
        private EntryLoader<K, V> entryLoader;

        private Builder() {
        }

        public <K1 extends K, V1 extends V> ExpiringMap<K1, V1> build() {
            return new ExpiringMap(this);
        }

        public Builder<K, V> expiration(long duration, TimeUnit timeUnit) {
            this.duration = duration;
            this.timeUnit = timeUnit;
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> entryLoader(EntryLoader<? super K1, ? super V1> loader) {
            this.entryLoader = loader;
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> expirationListener(ExpirationListener<? super K1, ? super V1> listener) {
            if (this.expirationListeners == null) {
                this.expirationListeners = new ArrayList<ExpirationListenerConfig<K, V>>();
            }
            this.expirationListeners.add(new ExpirationListenerConfig<K1, V1>(listener));
            return this;
        }

        public <K1 extends K, V1 extends V> Builder<K1, V1> expirationListeners(List<ExpirationListener<? super K1, ? super V1>> listeners) {
            if (this.expirationListeners == null) {
                this.expirationListeners = new ArrayList<ExpirationListenerConfig<K, V>>(listeners.size());
            }
            for (ExpirationListener<K1, V1> expirationListener : listeners) {
                this.expirationListeners.add(new ExpirationListenerConfig<K1, V1>(expirationListener));
            }
            return this;
        }

        public Builder<K, V> expirationPolicy(ExpirationPolicy expirationPolicy) {
            this.expirationPolicy = expirationPolicy;
            return this;
        }

        public Builder<K, V> variableExpiration() {
            this.variableExpiration = true;
            return this;
        }
    }
}

