/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;

public class FailsafeFuture<T>
extends CompletableFuture<T> {
    private final FailsafeExecutor<T> executor;
    private ExecutionContext execution;
    private Future<T> delegate;

    FailsafeFuture(FailsafeExecutor<T> executor) {
        this.executor = executor;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean cancelResult = super.cancel(mayInterruptIfRunning);
        if (this.delegate != null) {
            cancelResult = this.delegate.cancel(mayInterruptIfRunning);
        }
        CancellationException failure = new CancellationException();
        this.complete(null, failure);
        this.executor.handleComplete(ExecutionResult.failure(failure), this.execution);
        return cancelResult;
    }

    synchronized void complete(T result, Throwable failure) {
        if (this.isDone()) {
            return;
        }
        if (failure != null) {
            super.completeExceptionally(failure);
        } else {
            super.complete(result);
        }
    }

    public synchronized void inject(Future<T> delegate) {
        this.delegate = delegate;
    }

    void inject(ExecutionContext execution) {
        this.execution = execution;
    }
}

