/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jodah.lyra.config.ChannelConfig;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.event.ChannelListener;
import net.jodah.lyra.event.ConsumerListener;
import net.jodah.lyra.internal.ConnectionHandler;
import net.jodah.lyra.internal.Invocation;
import net.jodah.lyra.internal.RetryableResource;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;

public class ChannelHandler
extends RetryableResource
implements InvocationHandler {
    private final ConnectionHandler connectionHandler;
    private final Config config;
    private final AtomicBoolean recovering = new AtomicBoolean();
    Channel proxy;
    Channel delegate;
    private final Map<String, Invocation> consumerInvocations = Collections.synchronizedMap();
    private List<ConfirmListener> confirmListeners = new CopyOnWriteArrayList<ConfirmListener>();
    private List<FlowListener> flowListeners = new CopyOnWriteArrayList<FlowListener>();
    private List<ReturnListener> returnListeners = new CopyOnWriteArrayList<ReturnListener>();
    private boolean flowDisabled;
    private Invocation basicQos;
    private boolean confirmSelect;
    private boolean txSelect;

    public ChannelHandler(ConnectionHandler connectionHandler, Channel delegate, Config config) {
        this.connectionHandler = connectionHandler;
        this.delegate = delegate;
        this.config = config;
    }

    @Override
    public Object invoke(Object ignored, final Method method, final Object[] args) throws Throwable {
        if (this.closed) {
            throw new AlreadyClosedException("Attempt to use closed channel", (Object)this.proxy);
        }
        this.handleCommonMethods(this.delegate, method, args);
        return this.callWithRetries(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ChannelConfig.class.equals(method.getDeclaringClass())) {
                    return Reflection.invoke(ChannelHandler.this.config, method, args);
                }
                String methodName = method.getName();
                if ("basicCancel".equals(methodName) && args[0] != null) {
                    ChannelHandler.this.consumerInvocations.remove((String)args[0]);
                }
                Object result = Reflection.invoke(ChannelHandler.this.delegate, method, args);
                if ("basicConsume".equals(methodName)) {
                    if (args.length > 3) {
                        args[2] = result;
                    }
                    ChannelHandler.this.consumerInvocations.put((String)result, new Invocation(method, args));
                    ChannelHandler.this.log.info("Created consumer-{} of {} via {}", new Object[]{result, args[0], ChannelHandler.this});
                } else if ("flow".equals(methodName)) {
                    ChannelHandler.this.flowDisabled = (Boolean)args[0] == false;
                } else if ("basicQos".equals(methodName)) {
                    if (args.length < 3 || !((Boolean)args[2]).booleanValue()) {
                        ChannelHandler.this.basicQos = new Invocation(method, args);
                    }
                } else if ("confirmSelect".equals(methodName)) {
                    ChannelHandler.this.confirmSelect = true;
                } else if ("txSelect".equals(methodName)) {
                    ChannelHandler.this.txSelect = true;
                } else if ("addConfirmListener".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.add((ConfirmListener)args[0]);
                } else if ("addFlowListener".equals(methodName)) {
                    ChannelHandler.this.flowListeners.add((FlowListener)args[0]);
                } else if ("addReturnListener".equals(methodName)) {
                    ChannelHandler.this.returnListeners.add((ReturnListener)args[0]);
                } else if ("removeConfirmListener".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.remove((ConfirmListener)args[0]);
                } else if ("removeFlowListener".equals(methodName)) {
                    ChannelHandler.this.flowListeners.remove((FlowListener)args[0]);
                } else if ("removeReturnListener".equals(methodName)) {
                    ChannelHandler.this.returnListeners.remove((ReturnListener)args[0]);
                } else if ("clearConfirmListeners".equals(methodName)) {
                    ChannelHandler.this.confirmListeners.clear();
                } else if ("clearFlowListeners".equals(methodName)) {
                    ChannelHandler.this.flowListeners.clear();
                } else if ("clearReturnListeners".equals(methodName)) {
                    ChannelHandler.this.returnListeners.clear();
                }
                return result;
            }

            public String toString() {
                return Reflection.toString(method);
            }
        }, this.config.getChannelRetryPolicy(), false, true);
    }

    public String toString() {
        return String.format("channel-%s on %s", this.delegate.getChannelNumber(), this.connectionHandler);
    }

    @Override
    void afterClosure() {
        this.connectionHandler.removeChannel(this.delegate.getChannelNumber());
    }

    @Override
    boolean canRecover(boolean connectionClosed) {
        boolean recoverable;
        boolean bl = recoverable = this.config.getChannelRecoveryPolicy() != null && this.config.getChannelRecoveryPolicy().allowsRetries();
        return connectionClosed ? recoverable && this.connectionHandler.canRecover(connectionClosed) : recoverable;
    }

    @Override
    RetryableResource.RecoveryResult recoverChannel(boolean waitForRecovery) throws Exception {
        if (this.recovering.compareAndSet(false, true)) {
            if (waitForRecovery) {
                return this.recoverChannel();
            }
            ConnectionHandler.RECOVERY_EXECUTORS.submit(new Callable<RetryableResource.RecoveryResult>(){

                @Override
                public RetryableResource.RecoveryResult call() throws Exception {
                    return ChannelHandler.this.recoverChannel();
                }
            });
        }
        return RetryableResource.RecoveryResult.Pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized RetryableResource.RecoveryResult recoverChannel() throws Exception {
        if (this.circuit.isClosed()) {
            return RetryableResource.RecoveryResult.Succeeded;
        }
        final HashMap<String, Invocation> consumers = this.consumerInvocations.isEmpty() ? null : new HashMap<String, Invocation>(this.consumerInvocations);
        try {
            this.callWithRetries(new Callable<Channel>(){

                @Override
                public Channel call() throws Exception {
                    ChannelHandler.this.log.info("Recovering {} ", (Object)ChannelHandler.this);
                    Channel channel = ChannelHandler.this.connectionHandler.createChannel(ChannelHandler.this.delegate.getChannelNumber());
                    ChannelHandler.this.migrateConfiguration(channel);
                    ChannelHandler.this.delegate = channel;
                    if (ChannelHandler.this.config.isConsumerRecoveryEnabled()) {
                        ChannelHandler.this.recoverConsumers(channel, consumers);
                    }
                    ChannelHandler.this.circuit.close();
                    return channel;
                }
            }, this.config.getChannelRecoveryPolicy(), true, false);
            for (ChannelListener listener : this.config.getChannelListeners()) {
                listener.onRecovery(this.proxy);
            }
            Object i$ = RetryableResource.RecoveryResult.Succeeded;
            return i$;
        }
        catch (Exception e) {
            this.log.error("Failed to recover {}", (Object)this, (Object)e);
            this.interruptWaiters();
            for (ChannelListener listener : this.config.getChannelListeners()) {
                listener.onRecoveryFailure(this.proxy, e);
            }
            ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
            if (sse != null && Exceptions.isConnectionClosure(sse)) {
                throw e;
            }
            RetryableResource.RecoveryResult recoveryResult = RetryableResource.RecoveryResult.Failed;
            return recoveryResult;
        }
        finally {
            this.recovering.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateConfiguration(Channel channel) throws Exception {
        channel.setDefaultConsumer(this.delegate.getDefaultConsumer());
        if (this.flowDisabled) {
            channel.flow(false);
        }
        if (this.basicQos != null) {
            Reflection.invoke(channel, this.basicQos.method, this.basicQos.args);
        }
        if (this.confirmSelect) {
            channel.confirmSelect();
        }
        if (this.txSelect) {
            channel.txSelect();
        }
        List list = this.shutdownListeners;
        synchronized (list) {
            for (ShutdownListener listener : this.shutdownListeners) {
                channel.addShutdownListener(listener);
            }
        }
        for (ConfirmListener confirmListener : this.confirmListeners) {
            channel.addConfirmListener(confirmListener);
        }
        for (FlowListener flowListener : this.flowListeners) {
            channel.addFlowListener(flowListener);
        }
        for (ReturnListener returnListener : this.returnListeners) {
            channel.addReturnListener(returnListener);
        }
    }

    private void recoverConsumers(Channel channel, Map<String, Invocation> consumers) throws Exception {
        if (consumers != null) {
            for (Map.Entry<String, Invocation> entry : consumers.entrySet()) {
                Consumer consumer = (Consumer)entry.getValue().args[entry.getValue().args.length - 1];
                try {
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        listener.onBeforeRecovery(consumer, this.proxy);
                    }
                    this.log.info("Recovering consumer-{} via {}", (Object)entry.getKey(), (Object)this);
                    Reflection.invoke(channel, entry.getValue().method, entry.getValue().args);
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        listener.onAfterRecovery(consumer, this.proxy);
                    }
                }
                catch (Exception e) {
                    ShutdownSignalException sse = Exceptions.extractCause(e, ShutdownSignalException.class);
                    this.log.error("Failed to recover consumer-{} via {}", new Object[]{entry.getKey(), this, e});
                    for (ConsumerListener listener : this.config.getConsumerListeners()) {
                        listener.onRecoveryFailure(consumer, this.proxy, e);
                    }
                    if (sse == null) continue;
                    if (!Exceptions.isConnectionClosure(sse)) {
                        consumers.remove(entry.getKey());
                    }
                    throw e;
                }
            }
        }
    }
}

