/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import net.jodah.lyra.internal.RetryStats;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;
import net.jodah.lyra.internal.util.concurrent.InterruptableWaiter;
import net.jodah.lyra.internal.util.concurrent.ReentrantCircuit;
import net.jodah.lyra.retry.RetryPolicy;
import net.jodah.lyra.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RetryableResource {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final ReentrantCircuit circuit = new ReentrantCircuit();
    final InterruptableWaiter retryWaiter = new InterruptableWaiter();
    final List<ShutdownListener> shutdownListeners = Collections.synchronizedList();
    volatile boolean closed;

    RetryableResource() {
    }

    void afterClosure() {
    }

    <T> T callWithRetries(Callable<T> callable, RetryPolicy retryPolicy, boolean recovery, boolean logFailures) throws Exception {
        RetryStats retryStats = null;
        if (recovery) {
            if (retryPolicy == null || !retryPolicy.allowsRetries()) {
                return null;
            }
            retryStats = new RetryStats(retryPolicy);
            retryStats.canRetryForUpdatedStats();
        }
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                block19: {
                    boolean channelClosure;
                    ShutdownSignalException sse;
                    if (logFailures) {
                        this.log.error("Invocation of {} failed.", callable, (Object)e);
                    }
                    boolean connectionClosure = (sse = Exceptions.extractCause(e, ShutdownSignalException.class)) != null && Exceptions.isConnectionClosure(sse);
                    boolean bl = channelClosure = sse != null && !connectionClosure;
                    if (sse != null) {
                        if (channelClosure) {
                            this.circuit.open();
                        }
                        if (recovery && connectionClosure || !this.canRecover(connectionClosure)) {
                            throw e;
                        }
                    }
                    if (!this.closed) {
                        try {
                            RecoveryResult recoveryResult;
                            boolean recoveryNeeded;
                            boolean retryable = retryPolicy != null && retryPolicy.allowsRetries() && (recovery && channelClosure || Exceptions.isRetryable(e, sse));
                            long startTime = System.nanoTime();
                            boolean bl2 = recoveryNeeded = !recovery && sse != null;
                            RecoveryResult recoveryResult2 = recoveryNeeded ? (connectionClosure ? RecoveryResult.Pending : this.recoverChannel(retryable || recovery)) : (recoveryResult = null);
                            if (retryable && !RecoveryResult.Failed.equals((Object)recoveryResult)) {
                                if (RecoveryResult.Pending.equals((Object)recoveryResult)) {
                                    if (retryPolicy.getMaxDuration() == null) {
                                        this.circuit.await();
                                    } else if (!this.circuit.await(retryStats.getMaxWaitTime())) {
                                        this.log.debug("Exceeded max wait time while waiting for {} to recover", (Object)this);
                                        throw e;
                                    }
                                }
                                if (retryStats == null) {
                                    retryStats = new RetryStats(retryPolicy);
                                }
                                if (retryStats.canRetryForUpdatedStats()) {
                                    long remainingWaitTime = retryStats.getWaitTime().toNanos() - (System.nanoTime() - startTime);
                                    if (remainingWaitTime <= 0L) continue;
                                    this.retryWaiter.await(Duration.nanos(remainingWaitTime));
                                    continue;
                                }
                            }
                            break block19;
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                            break block19;
                        }
                        continue;
                    }
                }
                throw e;
            }
            break;
        }
    }

    abstract boolean canRecover(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleCommonMethods(Object delegate, Method method, Object[] args) throws Throwable {
        if ("abort".equals(method.getName()) || "close".equals(method.getName())) {
            try {
                Reflection.invoke(delegate, method, args);
                boolean bl = true;
                return bl;
            }
            finally {
                this.closed = true;
                this.afterClosure();
                this.interruptWaiters();
            }
        }
        if ("addShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.add((ShutdownListener)args[0]);
        } else if ("removeShutdownListener".equals(method.getName()) && args[0] != null) {
            this.shutdownListeners.remove((ShutdownListener)args[0]);
        }
        return false;
    }

    RecoveryResult recoverChannel(boolean waitForRecovery) throws Exception {
        return RecoveryResult.Failed;
    }

    void interruptWaiters() {
        this.circuit.interruptWaiters();
        this.retryWaiter.interruptWaiters();
    }

    static enum RecoveryResult {
        Succeeded,
        Failed,
        Pending;

    }
}

