/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.jodah.lyra.internal.util.Addresses;
import net.jodah.lyra.internal.util.Assert;
import net.jodah.lyra.util.Duration;

public class ConnectionOptions {
    private ConnectionFactory factory;
    private String host = "localhost";
    private Address[] addresses;
    private String name;
    private ExecutorService executor;

    public ConnectionOptions() {
        this.factory = new ConnectionFactory();
    }

    public ConnectionOptions(ConnectionFactory connectionFactory) {
        this.factory = Assert.notNull(connectionFactory, "connectionFactory");
        this.withHost(this.factory.getHost());
    }

    private ConnectionOptions(ConnectionOptions options) {
        this.factory = new ConnectionFactory();
        this.factory.setClientProperties(options.factory.getClientProperties());
        this.factory.setConnectionTimeout(options.factory.getConnectionTimeout());
        this.factory.setHost(options.factory.getHost());
        this.factory.setPort(options.factory.getPort());
        this.factory.setUsername(options.factory.getUsername());
        this.factory.setPassword(options.factory.getPassword());
        this.factory.setVirtualHost(options.factory.getVirtualHost());
        this.factory.setRequestedChannelMax(options.factory.getRequestedChannelMax());
        this.factory.setRequestedFrameMax(options.factory.getRequestedFrameMax());
        this.factory.setRequestedHeartbeat(options.factory.getRequestedHeartbeat());
        this.factory.setSaslConfig(options.factory.getSaslConfig());
        this.factory.setSocketFactory(options.factory.getSocketFactory());
        this.host = options.host;
        this.addresses = options.addresses;
        this.name = options.name;
        this.executor = options.executor;
    }

    public ConnectionOptions copy() {
        return new ConnectionOptions(this);
    }

    public Address[] getAddresses() {
        Address[] addressArray;
        if (this.addresses == null) {
            Address[] addressArray2 = new Address[1];
            addressArray = addressArray2;
            addressArray2[0] = new Address(this.host, this.factory.getPort());
        } else {
            addressArray = this.addresses;
        }
        return addressArray;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    public ExecutorService getConsumerExecutor() {
        return this.executor;
    }

    public String getName() {
        return this.name;
    }

    public ConnectionOptions withAddresses(Address ... addresses) {
        addresses = Assert.notNull(addresses, "addresses");
        return this;
    }

    public ConnectionOptions withAddresses(String addresses) {
        this.addresses = Address.parseAddresses((String)Assert.notNull(addresses, "addresses"));
        return this;
    }

    public ConnectionOptions withClientProperties(Map<String, Object> clientProperties) {
        this.factory.setClientProperties(Assert.notNull(clientProperties, "clientProperties"));
        return this;
    }

    public ConnectionOptions withConnectionFactory(ConnectionFactory connectionFactory) {
        this.factory = Assert.notNull(connectionFactory, "connectionFactory");
        return this;
    }

    public ConnectionOptions withConnectionTimeout(Duration connectionTimeout) {
        this.factory.setConnectionTimeout((int)connectionTimeout.toMillis());
        return this;
    }

    public ConnectionOptions withConsumerExecutor(ExecutorService executor) {
        this.executor = Assert.notNull(executor, "executor");
        return this;
    }

    public ConnectionOptions withHost(String host) {
        this.host = Assert.notNull(host, "host");
        return this;
    }

    public ConnectionOptions withHosts(String ... hosts) {
        this.addresses = Addresses.addressesFor(Assert.notNull(hosts, "hosts"), 5672);
        return this;
    }

    public ConnectionOptions withName(String name) {
        this.name = Assert.notNull(name, "name");
        return this;
    }

    public ConnectionOptions withPassword(String password) {
        this.factory.setPassword(password);
        return this;
    }

    public ConnectionOptions withPort(int port) {
        this.factory.setPort(port);
        return this;
    }

    public ConnectionOptions withRequestedHeartbeat(Duration requestedHeartbeat) {
        this.factory.setRequestedHeartbeat((int)requestedHeartbeat.toMillis());
        return this;
    }

    public ConnectionOptions withSocketFactory(SocketFactory socketFactory) {
        this.factory.setSocketFactory(Assert.notNull(socketFactory, "socketFactory"));
        return this;
    }

    public ConnectionOptions withSsl() throws NoSuchAlgorithmException, KeyManagementException {
        this.factory.useSslProtocol();
        return this;
    }

    public ConnectionOptions withSslProtocol(SSLContext sslContext) {
        this.factory.useSslProtocol(sslContext);
        return this;
    }

    public ConnectionOptions withSslProtocol(String sslProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        this.factory.useSslProtocol(Assert.notNull(sslProtocol, "sslProtocol"));
        return this;
    }

    public ConnectionOptions withSslProtocol(String sslProtocol, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        this.factory.useSslProtocol(Assert.notNull(sslProtocol, "sslProtocol"), Assert.notNull(trustManager, "trustManager"));
        return this;
    }

    public ConnectionOptions withUsername(String username) {
        this.factory.setUsername(Assert.notNull(username, "username"));
        return this;
    }

    public ConnectionOptions withVirtualHost(String virtualHost) {
        this.factory.setVirtualHost(Assert.notNull(virtualHost, "virtualHost"));
        return this;
    }
}

