/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import net.jodah.lyra.internal.ChannelHandler;

public class ConsumerDelegate
implements Consumer {
    private final ChannelHandler channelHandler;
    final Consumer delegate;
    private volatile boolean closed;

    ConsumerDelegate(ChannelHandler channelHandler, Consumer delegate) {
        this.channelHandler = channelHandler;
        this.delegate = delegate;
    }

    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    public void handleCancel(String consumerTag) throws IOException {
        this.delegate.handleCancel(consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.delegate.handleCancelOk(consumerTag);
    }

    public void handleConsumeOk(String consumerTag) {
        this.delegate.handleConsumeOk(consumerTag);
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        if (this.closed) {
            return;
        }
        long deliveryTag = envelope.getDeliveryTag();
        this.channelHandler.maxDeliveryTag = deliveryTag += this.channelHandler.previousMaxDeliveryTag;
        this.delegate.handleDelivery(consumerTag, new Envelope(deliveryTag, envelope.isRedeliver(), envelope.getExchange(), envelope.getRoutingKey()), properties, body);
    }

    public void handleRecoverOk(String consumerTag) {
        this.delegate.handleRecoverOk(consumerTag);
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this.delegate.handleShutdownSignal(consumerTag, sig);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    void close() {
        this.closed = true;
    }

    void open() {
        this.closed = false;
    }
}

