/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal.util;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.EOFException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;

public final class Exceptions {
    private Exceptions() {
    }

    public static <T extends Throwable> T extractCause(Throwable t, Class<T> type) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!type.isAssignableFrom(cause.getClass())) continue;
            return (T)cause;
        }
        return null;
    }

    public static boolean isConnectionClosure(ShutdownSignalException e) {
        return e instanceof AlreadyClosedException ? e.getReference() instanceof Connection : e.isHardError();
    }

    public static boolean isRetryable(Exception e, ShutdownSignalException sse) {
        if (e instanceof SocketTimeoutException || e instanceof ConnectException || e instanceof AlreadyClosedException || e.getCause() instanceof EOFException) {
            return true;
        }
        if (e instanceof PossibleAuthenticationFailureException) {
            return false;
        }
        return sse != null && Exceptions.isRetryable(sse);
    }

    private static boolean isRetryable(int failureCode) {
        switch (failureCode) {
            case 311: {
                return true;
            }
            case 313: {
                return false;
            }
            case 403: {
                return false;
            }
            case 404: {
                return false;
            }
            case 405: {
                return false;
            }
            case 406: {
                return false;
            }
            case 320: {
                return true;
            }
            case 402: {
                return false;
            }
            case 501: {
                return false;
            }
            case 502: {
                return false;
            }
            case 503: {
                return false;
            }
            case 504: {
                return false;
            }
            case 505: {
                return false;
            }
            case 506: {
                return false;
            }
            case 530: {
                return false;
            }
            case 540: {
                return false;
            }
            case 541: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetryable(ShutdownSignalException e) {
        if (e.isInitiatedByApplication()) {
            return false;
        }
        Object reason = e.getReason();
        if (reason instanceof Command) {
            Command command = (Command)reason;
            Method method = command.getMethod();
            if (method instanceof AMQP.Connection.Close) {
                return Exceptions.isRetryable(((AMQP.Connection.Close)method).getReplyCode());
            }
            if (method instanceof AMQP.Channel.Close) {
                return Exceptions.isRetryable(((AMQP.Channel.Close)method).getReplyCode());
            }
        }
        return false;
    }
}

