/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal.util.concurrent;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import net.jodah.lyra.util.Duration;

public class ReentrantCircuit {
    private final Sync sync = new Sync();

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(0);
    }

    public boolean await(Duration waitDuration) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(0, waitDuration.toNanos());
    }

    public void close() {
        this.sync.releaseShared(1);
    }

    public void interruptWaiters() {
        for (Thread t : this.sync.getSharedQueuedThreads()) {
            t.interrupt();
        }
    }

    public boolean isClosed() {
        return this.sync.isClosed();
    }

    public void open() {
        this.sync.open();
    }

    public String toString() {
        return this.isClosed() ? "closed" : "open";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 992522674231731445L;

        private Sync() {
        }

        @Override
        public boolean tryReleaseShared(int ignored) {
            this.setState(0);
            return true;
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            Thread queuedThread = this.getFirstQueuedThread();
            if (queuedThread != null && queuedThread != Thread.currentThread()) {
                return -1;
            }
            if (acquires == 0) {
                return this.isClosed() ? 1 : -1;
            }
            this.setState(1);
            return 1;
        }

        private boolean isClosed() {
            return this.getState() == 0;
        }

        private void open() {
            this.setState(1);
        }
    }
}

