/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.jodah.lyra.internal.util.Assert;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 8408159221215361695L;
    public static final Duration INFINITE = new Duration();
    private static final Pattern PATTERN = Pattern.compile("[\\d]+[\\s]*(ns|nanosecond(s)?|us|microsecond(s)?|ms|millisecond(s)?|s|second(s)?|m|minute(s)?|h|hour(s)?|d|day(s)?)");
    private static final Map<String, TimeUnit> SUFFIXES = new HashMap<String, TimeUnit>();
    public final long length;
    public final TimeUnit timeUnit;
    public final boolean finite;

    private Duration() {
        this.finite = false;
        this.length = Long.MAX_VALUE;
        this.timeUnit = TimeUnit.DAYS;
    }

    private Duration(long length, TimeUnit timeUnit) {
        this.length = length;
        this.timeUnit = Assert.notNull(timeUnit, "timeUnit");
        this.finite = length != Long.MAX_VALUE || !TimeUnit.DAYS.equals((Object)timeUnit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Duration duration = (Duration)obj;
        return this.length == duration.length && this.timeUnit == duration.timeUnit;
    }

    public int hashCode() {
        return 31 * (int)(this.length ^ this.length >>> 32) + this.timeUnit.hashCode();
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.length, this.timeUnit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.length, this.timeUnit);
    }

    public long toMicros() {
        return TimeUnit.MICROSECONDS.convert(this.length, this.timeUnit);
    }

    public long toMicroseconds() {
        return TimeUnit.MICROSECONDS.convert(this.length, this.timeUnit);
    }

    public long toMillis() {
        return TimeUnit.MILLISECONDS.convert(this.length, this.timeUnit);
    }

    public long toMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.length, this.timeUnit);
    }

    public long toMins() {
        return TimeUnit.MINUTES.convert(this.length, this.timeUnit);
    }

    public long toMinutes() {
        return TimeUnit.MINUTES.convert(this.length, this.timeUnit);
    }

    public long toNanos() {
        return TimeUnit.NANOSECONDS.convert(this.length, this.timeUnit);
    }

    public long toNanoseconds() {
        return TimeUnit.NANOSECONDS.convert(this.length, this.timeUnit);
    }

    public long toSeconds() {
        return TimeUnit.SECONDS.convert(this.length, this.timeUnit);
    }

    public long toSecs() {
        return TimeUnit.SECONDS.convert(this.length, this.timeUnit);
    }

    public String toString() {
        String units = this.timeUnit.toString().toLowerCase();
        if (this.length == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.length) + ' ' + units;
    }

    public static Duration days(long count) {
        return new Duration(count, TimeUnit.DAYS);
    }

    public static Duration hours(long count) {
        return new Duration(count, TimeUnit.HOURS);
    }

    public static Duration inf() {
        return INFINITE;
    }

    public static Duration infinite() {
        return INFINITE;
    }

    public static Duration microseconds(long count) {
        return new Duration(count, TimeUnit.MICROSECONDS);
    }

    public static Duration millis(long count) {
        return new Duration(count, TimeUnit.MILLISECONDS);
    }

    public static Duration milliseconds(long count) {
        return new Duration(count, TimeUnit.MILLISECONDS);
    }

    public static Duration mins(long count) {
        return new Duration(count, TimeUnit.MINUTES);
    }

    public static Duration minutes(long count) {
        return new Duration(count, TimeUnit.MINUTES);
    }

    public static Duration nanos(long count) {
        return new Duration(count, TimeUnit.NANOSECONDS);
    }

    public static Duration nanoseconds(long count) {
        return new Duration(count, TimeUnit.NANOSECONDS);
    }

    public static Duration of(long count, TimeUnit unit) {
        return new Duration(count, unit);
    }

    public static Duration of(String duration) {
        int i;
        Assert.isTrue(PATTERN.matcher(duration).matches(), "Invalid duration: %s", duration);
        for (i = 0; i < duration.length() && !Character.isLetter(duration.charAt(i)); ++i) {
        }
        String unit = duration.subSequence(0, i).toString().trim();
        String dur = duration.subSequence(i, duration.length()).toString();
        return new Duration(Long.parseLong(unit), SUFFIXES.get(dur));
    }

    public static Duration seconds(long count) {
        return new Duration(count, TimeUnit.SECONDS);
    }

    public static Duration secs(long count) {
        return new Duration(count, TimeUnit.SECONDS);
    }

    static {
        SUFFIXES.put("ns", TimeUnit.NANOSECONDS);
        SUFFIXES.put("nanosecond", TimeUnit.NANOSECONDS);
        SUFFIXES.put("nanoseconds", TimeUnit.NANOSECONDS);
        SUFFIXES.put("us", TimeUnit.MICROSECONDS);
        SUFFIXES.put("microsecond", TimeUnit.MICROSECONDS);
        SUFFIXES.put("microseconds", TimeUnit.MICROSECONDS);
        SUFFIXES.put("ms", TimeUnit.MILLISECONDS);
        SUFFIXES.put("millisecond", TimeUnit.MILLISECONDS);
        SUFFIXES.put("milliseconds", TimeUnit.MILLISECONDS);
        SUFFIXES.put("s", TimeUnit.SECONDS);
        SUFFIXES.put("second", TimeUnit.SECONDS);
        SUFFIXES.put("seconds", TimeUnit.SECONDS);
        SUFFIXES.put("m", TimeUnit.MINUTES);
        SUFFIXES.put("minute", TimeUnit.MINUTES);
        SUFFIXES.put("minutes", TimeUnit.MINUTES);
        SUFFIXES.put("h", TimeUnit.HOURS);
        SUFFIXES.put("hour", TimeUnit.HOURS);
        SUFFIXES.put("hours", TimeUnit.HOURS);
        SUFFIXES.put("d", TimeUnit.DAYS);
        SUFFIXES.put("day", TimeUnit.DAYS);
        SUFFIXES.put("days", TimeUnit.DAYS);
    }
}

