/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.jodah.lyra.ConnectionOptions;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.config.ConfigurableChannel;
import net.jodah.lyra.config.ConnectionConfig;
import net.jodah.lyra.event.ChannelListener;
import net.jodah.lyra.event.ConnectionListener;
import net.jodah.lyra.internal.Binding;
import net.jodah.lyra.internal.ChannelHandler;
import net.jodah.lyra.internal.QueueDeclaration;
import net.jodah.lyra.internal.RecurringPolicy;
import net.jodah.lyra.internal.RecurringStats;
import net.jodah.lyra.internal.ResourceDeclaration;
import net.jodah.lyra.internal.RetryableResource;
import net.jodah.lyra.internal.util.ArrayListMultiMap;
import net.jodah.lyra.internal.util.Collections;
import net.jodah.lyra.internal.util.Exceptions;
import net.jodah.lyra.internal.util.Reflection;
import net.jodah.lyra.internal.util.concurrent.NamedThreadFactory;

public class ConnectionHandler
extends RetryableResource
implements InvocationHandler {
    private static final Class<?>[] CHANNEL_TYPES = new Class[]{ConfigurableChannel.class};
    private static final AtomicInteger CONNECTION_COUNTER = new AtomicInteger();
    static final ExecutorService RECOVERY_EXECUTORS = Executors.newCachedThreadPool(new NamedThreadFactory("lyra-recovery-%s"));
    static final int RECOVERY_CHANNEL_NUM = 100;
    final Map<String, ResourceDeclaration> exchangeDeclarations = Collections.synchronizedLinkedMap();
    final ArrayListMultiMap<String, Binding> exchangeBindings = Collections.arrayListMultiMap();
    final Map<String, QueueDeclaration> queueDeclarations = Collections.synchronizedLinkedMap();
    final ArrayListMultiMap<String, Binding> queueBindings = Collections.arrayListMultiMap();
    private final ConnectionOptions options;
    private final Config config;
    private final String connectionName;
    private final ExecutorService consumerThreadPool;
    private final Map<String, ChannelHandler> channels = new ConcurrentHashMap<String, ChannelHandler>();
    private Connection proxy;
    private Connection delegate;
    private Channel recoveryChannel;

    public ConnectionHandler(ConnectionOptions options, Config config) throws IOException {
        this.options = options;
        this.config = config;
        this.connectionName = options.getName() == null ? String.format("cxn-%s", CONNECTION_COUNTER.incrementAndGet()) : options.getName();
        this.consumerThreadPool = options.getConsumerExecutor() == null ? Executors.newCachedThreadPool(new NamedThreadFactory(String.format("rabbitmq-%s-consumer", this.connectionName))) : options.getConsumerExecutor();
    }

    public void createConnection(Connection proxy) throws IOException {
        try {
            this.proxy = proxy;
            this.createConnection(this.config.getConnectRetryPolicy(), false);
            ConnectionShutdownListener shutdownListener = new ConnectionShutdownListener();
            this.shutdownListeners.add(shutdownListener);
            this.delegate.addShutdownListener((ShutdownListener)shutdownListener);
            for (ConnectionListener listener : this.config.getConnectionListeners()) {
                try {
                    listener.onCreate(proxy);
                }
                catch (Exception ignore) {}
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create connection {}", (Object)this.connectionName, (Object)e);
            this.connectionClosed();
            for (ConnectionListener listener : this.config.getConnectionListeners()) {
                try {
                    listener.onCreateFailure(e);
                }
                catch (Exception ignore) {}
            }
            throw e;
        }
    }

    @Override
    public Object invoke(Object ignored, final Method method, final Object[] args) throws Throwable {
        if (this.handleCommonMethods(this.delegate, method, args)) {
            return null;
        }
        try {
            return this.callWithRetries(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if ("createChannel".equals(method.getName())) {
                        Channel channelProxy;
                        Channel channel = (Channel)Reflection.invoke(ConnectionHandler.this.delegate, method, args);
                        ChannelHandler channelHandler = new ChannelHandler(ConnectionHandler.this, channel, new Config(ConnectionHandler.this.config));
                        channelHandler.proxy = channelProxy = (Channel)Proxy.newProxyInstance(Connection.class.getClassLoader(), CHANNEL_TYPES, (InvocationHandler)channelHandler);
                        ConnectionHandler.this.channels.put(Integer.valueOf(channel.getChannelNumber()).toString(), channelHandler);
                        ConnectionHandler.this.log.info("Created {}", (Object)channelHandler);
                        for (ChannelListener listener : ConnectionHandler.this.config.getChannelListeners()) {
                            try {
                                listener.onCreate(channelProxy);
                            }
                            catch (Exception ignore) {}
                        }
                        return channelProxy;
                    }
                    return Reflection.invoke(method.getDeclaringClass().isAssignableFrom(ConnectionConfig.class) ? ConnectionHandler.this.config : ConnectionHandler.this.delegate, method, args);
                }

                public String toString() {
                    return Reflection.toString(method);
                }
            }, this.config.getConnectionRetryPolicy(), null, this.canRecover(), true);
        }
        catch (Throwable t) {
            if ("createChannel".equals(method.getName())) {
                this.log.error("Failed to create channel on {}", (Object)this.connectionName, (Object)t);
                for (ChannelListener listener : this.config.getChannelListeners()) {
                    try {
                        listener.onCreateFailure(t);
                    }
                    catch (Exception ignore) {}
                }
            }
            throw t;
        }
    }

    public String toString() {
        return this.connectionName;
    }

    boolean canRecover() {
        return this.config.getConnectionRecoveryPolicy() != null && this.config.getConnectionRecoveryPolicy().allowsAttempts();
    }

    Channel createChannel(int channelNumber) throws IOException {
        return this.delegate.createChannel(channelNumber);
    }

    void removeChannel(int channelNumber) {
        this.channels.remove(Integer.valueOf(channelNumber).toString());
    }

    private void connectionClosed() {
        if (this.options.getConsumerExecutor() == null) {
            this.consumerThreadPool.shutdown();
        }
    }

    private void connectionShutdown() {
        this.circuit.open();
        for (ChannelHandler channelHandler : this.channels.values()) {
            channelHandler.channelShutdown();
        }
    }

    private void createConnection(RecurringPolicy<?> recurringPolicy, final boolean recovery) throws IOException {
        block4: {
            try {
                RecurringStats recurringStats = null;
                if (recovery) {
                    recurringStats = new RecurringStats(recurringPolicy);
                    recurringStats.incrementTime();
                }
                this.delegate = this.callWithRetries(new Callable<Connection>(){

                    @Override
                    public Connection call() throws IOException {
                        ConnectionHandler.this.log.info("{} connection {} to {}", new Object[]{recovery ? "Recovering" : "Creating", ConnectionHandler.this.connectionName, ConnectionHandler.this.options.getAddresses()});
                        ConnectionFactory cxnFactory = ConnectionHandler.this.options.getConnectionFactory();
                        Connection connection = cxnFactory.newConnection(ConnectionHandler.this.consumerThreadPool, ConnectionHandler.this.options.getAddresses());
                        String amqpAddress = String.format("%s://%s:%s/%s", cxnFactory.isSSL() ? "amqps" : "amqp", connection.getAddress().getHostAddress(), connection.getPort(), "/".equals(cxnFactory.getVirtualHost()) ? "" : cxnFactory.getVirtualHost());
                        ConnectionHandler.this.log.info("{} connection {} to {}", new Object[]{recovery ? "Recovered" : "Created", ConnectionHandler.this.connectionName, amqpAddress});
                        return connection;
                    }
                }, recurringPolicy, recurringStats, true, false);
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (!(t instanceof RuntimeException)) break block4;
                throw (RuntimeException)t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverConnection() throws Exception {
        this.createConnection(this.config.getConnectionRecoveryPolicy(), true);
        List list = this.shutdownListeners;
        synchronized (list) {
            for (ShutdownListener listener : this.shutdownListeners) {
                this.delegate.addShutdownListener(listener);
            }
        }
        for (ConnectionListener listener : this.config.getConnectionListeners()) {
            try {
                listener.onRecovery(this.proxy);
            }
            catch (Exception ignore) {}
        }
        this.recoverExchangesAndQueues();
        for (ChannelHandler channelHandler : this.channels.values()) {
            if (!channelHandler.canRecover()) continue;
            channelHandler.recoverChannel(true);
        }
        for (ConnectionListener listener : this.config.getConnectionListeners()) {
            try {
                listener.onChannelRecovery(this.proxy);
            }
            catch (Exception exception) {}
        }
        this.circuit.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverExchangesAndQueues() throws Exception {
        boolean canRecoverQueues;
        boolean canRecoverExchanges = this.config.isExchangeRecoveryEnabled() && (!this.exchangeDeclarations.isEmpty() || !this.exchangeBindings.isEmpty());
        boolean bl = canRecoverQueues = this.config.isQueueRecoveryEnabled() && (!this.queueDeclarations.isEmpty() || !this.queueBindings.isEmpty());
        if (canRecoverExchanges || canRecoverQueues) {
            try {
                if (canRecoverExchanges) {
                    this.recoverExchanges();
                }
                if (canRecoverQueues) {
                    this.recoverQueues();
                }
            }
            finally {
                try {
                    if (this.recoveryChannel != null && this.recoveryChannel.isOpen()) {
                        this.recoveryChannel.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void recoverExchanges() throws Exception {
        for (Map.Entry<String, ResourceDeclaration> entry : this.exchangeDeclarations.entrySet()) {
            this.recoverExchange(entry.getKey(), entry.getValue());
        }
        this.recoverExchangeBindings(this.exchangeBindings.values());
    }

    private void recoverQueues() throws Exception {
        HashMap<String, QueueDeclaration> newDeclarations = new HashMap<String, QueueDeclaration>();
        Iterator<Map.Entry<String, QueueDeclaration>> it = this.queueDeclarations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, QueueDeclaration> entry = it.next();
            String queueName = entry.getKey();
            QueueDeclaration queueDeclaration = entry.getValue();
            String newQueueName = this.recoverQueue(queueName, queueDeclaration);
            if (entry.getKey().equals(newQueueName)) continue;
            it.remove();
            newDeclarations.put(newQueueName, queueDeclaration);
            this.updateQueueBindingReferences(queueName, newQueueName);
        }
        this.queueDeclarations.putAll(newDeclarations);
        this.recoverQueueBindings(this.queueBindings.values());
    }

    void updateQueueBindingReferences(String oldQueueName, String newQueueName) {
        List<Binding> bindings = this.queueBindings.remove(oldQueueName);
        if (bindings != null) {
            for (Binding binding : bindings) {
                binding.destination = newQueueName;
            }
            this.queueBindings.putAll(newQueueName, bindings);
        }
    }

    @Override
    Channel getRecoveryChannel() throws IOException {
        if (this.recoveryChannel == null || !this.recoveryChannel.isOpen()) {
            this.recoveryChannel = this.delegate.createChannel(100);
        }
        return this.recoveryChannel;
    }

    @Override
    boolean throwOnRecoveryFailure() {
        return false;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RECOVERY_EXECUTORS.shutdownNow();
            }
        });
    }

    private class ConnectionShutdownListener
    implements ShutdownListener {
        private ConnectionShutdownListener() {
        }

        public void shutdownCompleted(ShutdownSignalException e) {
            ConnectionHandler.this.connectionShutdown();
            if (!e.isInitiatedByApplication()) {
                ConnectionHandler.this.log.error("Connection {} was closed unexpectedly", (Object)ConnectionHandler.this);
                if (ConnectionHandler.this.canRecover()) {
                    RECOVERY_EXECUTORS.execute(new Runnable(){

                        @Override
                        public void run() {
                            block5: {
                                try {
                                    ConnectionHandler.this.recoverConnection();
                                }
                                catch (Exception e) {
                                    if (Exceptions.isCausedByConnectionClosure(e)) break block5;
                                    ConnectionHandler.this.log.error("Failed to recover connection {}", (Object)ConnectionHandler.this, (Object)e);
                                    ConnectionHandler.this.connectionClosed();
                                    ConnectionHandler.this.interruptWaiters();
                                    for (ConnectionListener listener : ConnectionHandler.this.config.getConnectionListeners()) {
                                        try {
                                            listener.onRecoveryFailure(ConnectionHandler.this.proxy, e);
                                        }
                                        catch (Exception ignore) {}
                                    }
                                }
                            }
                        }
                    });
                }
            } else {
                ConnectionHandler.this.connectionClosed();
            }
        }
    }
}

