/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra.internal;

import net.jodah.lyra.internal.util.Assert;
import net.jodah.lyra.util.Duration;

public abstract class RecurringPolicy<T extends RecurringPolicy<T>> {
    private int maxAttempts = -1;
    private Duration maxDuration;
    private Duration interval;
    private Duration maxInterval;
    private int intervalMultiplier;

    public boolean allowsAttempts() {
        return !(this.maxAttempts != -1 && this.maxAttempts <= 0 || this.maxDuration != null && this.maxDuration.length <= 0L);
    }

    public Duration getInterval() {
        return this.interval;
    }

    public int getIntervalMultiplier() {
        return this.intervalMultiplier;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public Duration getMaxInterval() {
        return this.maxInterval;
    }

    public T withBackoff(Duration interval, Duration maxInterval) {
        return this.withBackoff(interval, maxInterval, 2);
    }

    public T withBackoff(Duration interval, Duration maxInterval, int intervalMultiplier) {
        Assert.notNull(interval, "interval");
        Assert.notNull(maxInterval, "maxInterval");
        Assert.isTrue(interval.length > 0L, "The interval must be greater than 0", new Object[0]);
        Assert.isTrue(interval.toNanoseconds() < maxInterval.toNanoseconds(), "The interval must be less than the maxInterval", new Object[0]);
        Assert.isTrue(intervalMultiplier > 1, "The intervalMultiplier must be greater than 1", new Object[0]);
        this.interval = interval;
        this.maxInterval = maxInterval;
        this.intervalMultiplier = intervalMultiplier;
        return (T)this;
    }

    public T withInterval(Duration interval) {
        Assert.notNull(interval, "interval");
        Assert.state(this.maxInterval == null, "Backoff intervals have already been set", new Object[0]);
        this.interval = interval;
        return (T)this;
    }

    public T withMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return (T)this;
    }

    public T withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        this.maxDuration = maxDuration;
        return (T)this;
    }
}

