/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.lyra;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeoutException;
import net.jodah.lyra.ConnectionOptions;
import net.jodah.lyra.config.Config;
import net.jodah.lyra.config.ConfigurableConnection;
import net.jodah.lyra.internal.ConnectionHandler;
import net.jodah.lyra.internal.util.Assert;

public final class Connections {
    private static final Class<?>[] CONNECTION_TYPES = new Class[]{ConfigurableConnection.class};
    private static final String CLASS_LOADER_PARAMETER_NAME = "classLoader";
    private static final ClassLoader DEFAULT_CLASS_LOADER = Connection.class.getClassLoader();

    private Connections() {
    }

    public static ConfigurableConnection create(Config config) throws IOException, TimeoutException {
        return Connections.create(new ConnectionOptions(), config, DEFAULT_CLASS_LOADER);
    }

    public static ConfigurableConnection create(Config config, ClassLoader classLoader) throws IOException, TimeoutException {
        Assert.notNull(classLoader, CLASS_LOADER_PARAMETER_NAME);
        return Connections.create(new ConnectionOptions(), config, classLoader);
    }

    public static ConfigurableConnection create(ConnectionFactory connectionFactory, Config config) throws IOException, TimeoutException {
        Assert.notNull(connectionFactory, "connectionFactory");
        return Connections.create(new ConnectionOptions(connectionFactory), config, DEFAULT_CLASS_LOADER);
    }

    public static ConfigurableConnection create(ConnectionFactory connectionFactory, Config config, ClassLoader classLoader) throws IOException, TimeoutException {
        Assert.notNull(connectionFactory, "connectionFactory");
        Assert.notNull(classLoader, CLASS_LOADER_PARAMETER_NAME);
        return Connections.create(new ConnectionOptions(connectionFactory), config, classLoader);
    }

    public static ConfigurableConnection create(ConnectionOptions options, Config config) throws IOException, TimeoutException {
        Assert.notNull(options, "options");
        Assert.notNull(config, "config");
        return Connections.create(options, config, DEFAULT_CLASS_LOADER);
    }

    public static ConfigurableConnection create(ConnectionOptions options, Config config, ClassLoader classLoader) throws IOException, TimeoutException {
        Assert.notNull(options, "options");
        Assert.notNull(config, "config");
        Assert.notNull(classLoader, CLASS_LOADER_PARAMETER_NAME);
        ConnectionHandler handler = new ConnectionHandler(options.copy(), new Config(config), classLoader);
        ConfigurableConnection proxy = (ConfigurableConnection)Proxy.newProxyInstance(classLoader, CONNECTION_TYPES, (InvocationHandler)handler);
        handler.createConnection(proxy);
        return proxy;
    }
}

