/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.Duration;

public class Invocation {
    final RetryPolicy retryPolicy;
    private final long startTime;
    volatile int retryCount;
    volatile long waitTime;
    volatile boolean retryRequested;
    volatile boolean completionRequested;
    volatile Object result;
    volatile Throwable failure;

    Invocation(RetryPolicy retryPolicy, RecurrentFuture<?> future) {
        this.retryPolicy = retryPolicy;
        this.waitTime = retryPolicy.getDelay().toNanos();
        this.startTime = System.nanoTime();
    }

    public void complete() {
        this.complete(null);
    }

    public void completeExceptionally(Throwable failure) {
        Assert.state(!this.completionRequested, "Retry has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.failure = failure;
    }

    public void complete(Object result) {
        Assert.state(!this.completionRequested, "Retry has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.result = result;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean retry() {
        return this.retryInternal(null);
    }

    public boolean retry(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryInternal(failure);
    }

    private boolean retryInternal(Throwable failure) {
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        Assert.state(!this.completionRequested, "Retry has already been called", new Object[0]);
        this.recordFailedAttempt();
        if ((failure == null || this.retryPolicy.allowsRetriesFor(failure)) && !this.isPolicyExceeded()) {
            this.retryRequested = true;
            return true;
        }
        if (failure == null) {
            failure = new RuntimeException("Retry invocations exceeded");
        }
        this.completeExceptionally(failure);
        return false;
    }

    Duration getWaitTime() {
        return new Duration(this.waitTime, TimeUnit.NANOSECONDS);
    }

    boolean isPolicyExceeded() {
        boolean withinMaxRetries = this.retryPolicy.getMaxRetries() == -1 || this.retryCount <= this.retryPolicy.getMaxRetries();
        boolean withinMaxDuration = this.retryPolicy.getMaxDuration() == null || System.nanoTime() - this.startTime < this.retryPolicy.getMaxDuration().toNanos();
        return !withinMaxRetries || !withinMaxDuration;
    }

    void recordFailedAttempt() {
        ++this.retryCount;
        this.adjustForBackoffs();
        this.adjustForMaxDuration();
    }

    void adjustForBackoffs() {
        if (this.retryPolicy.getMaxDelay() != null) {
            this.waitTime = (long)Math.min((double)this.waitTime * this.retryPolicy.getDelayMultiplier(), (double)this.retryPolicy.getMaxDelay().toNanos());
        }
    }

    void adjustForMaxDuration() {
        if (this.retryPolicy.getMaxDuration() != null) {
            long elapsedNanos = System.nanoTime() - this.startTime;
            long maxRemainingWaitTime = this.retryPolicy.getMaxDuration().toNanos() - elapsedNanos;
            this.waitTime = Math.min(this.waitTime, maxRemainingWaitTime < 0L ? 0L : maxRemainingWaitTime);
            if (this.waitTime < 0L) {
                this.waitTime = 0L;
            }
        }
    }
}

