/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.event.CompletionListener;
import net.jodah.recurrent.event.FailureListener;
import net.jodah.recurrent.event.SuccessListener;
import net.jodah.recurrent.internal.util.concurrent.ReentrantCircuit;

public class RecurrentFuture<T>
implements Future<T> {
    private final ExecutorService executor;
    private volatile Future<T> delegate;
    private volatile boolean done;
    private volatile boolean cancelled;
    private volatile ReentrantCircuit circuit = new ReentrantCircuit();
    private volatile T result;
    private volatile Throwable failure;
    private volatile CompletionListener<T> completionListener;
    private volatile CompletionListener<T> asyncCompletionListener;
    private volatile ExecutorService completionExecutor;
    private volatile SuccessListener<T> successListener;
    private volatile SuccessListener<T> asyncSuccessListener;
    private volatile ExecutorService successExecutor;
    private volatile FailureListener failureListener;
    private volatile FailureListener asyncFailureListener;
    private volatile ExecutorService failureExecutor;

    RecurrentFuture(ScheduledExecutorService executor) {
        this.executor = executor;
        this.circuit.open();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.delegate.cancel(mayInterruptIfRunning);
        this.cancelled = true;
        this.circuit.close();
        return result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.circuit.await();
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.circuit.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public RecurrentFuture<T> whenComplete(CompletionListener<T> completionListener) {
        if (!this.done) {
            this.completionListener = completionListener;
        } else {
            completionListener.onCompletion(this.result, this.failure);
        }
        return this;
    }

    public RecurrentFuture<T> whenCompleteAsync(CompletionListener<T> completionListener) {
        if (this.done) {
            this.executor.submit(Callables.of(completionListener, this.result, this.failure));
        } else {
            this.completionListener = completionListener;
        }
        return this;
    }

    public RecurrentFuture<T> whenCompleteAsync(CompletionListener<T> completionListener, ExecutorService executor) {
        if (this.done) {
            executor.submit(Callables.of(completionListener, this.result, this.failure));
        } else {
            this.asyncCompletionListener = completionListener;
            this.completionExecutor = executor;
        }
        return this;
    }

    public RecurrentFuture<T> whenFailure(FailureListener failureListener) {
        if (!this.done) {
            this.failureListener = failureListener;
        } else {
            failureListener.onFailure(this.failure);
        }
        return this;
    }

    public RecurrentFuture<T> whenFailureAsync(FailureListener failureListener) {
        if (this.done) {
            this.executor.submit(Callables.of(failureListener, this.failure));
        } else {
            this.failureListener = failureListener;
        }
        return this;
    }

    public RecurrentFuture<T> whenFailureAsync(FailureListener failureListener, ScheduledExecutorService executor) {
        if (this.done) {
            executor.submit(Callables.of(failureListener, this.failure));
        } else {
            this.asyncFailureListener = failureListener;
            this.failureExecutor = executor;
        }
        return this;
    }

    public RecurrentFuture<T> whenSuccess(SuccessListener<T> successListener) {
        if (!this.done) {
            this.successListener = successListener;
        } else {
            successListener.onSuccess(this.result);
        }
        return this;
    }

    public RecurrentFuture<T> whenSuccessAsync(SuccessListener<T> successListener) {
        if (this.done) {
            this.executor.submit(Callables.of(successListener, this.result));
        } else {
            this.successListener = successListener;
        }
        return this;
    }

    public RecurrentFuture<T> whenSuccessAsync(SuccessListener<T> successListener, ScheduledExecutorService executor) {
        if (this.done) {
            executor.submit(Callables.of(successListener, this.result));
        } else {
            this.asyncSuccessListener = successListener;
            this.successExecutor = executor;
        }
        return this;
    }

    synchronized void complete(T result, Throwable failure) {
        this.result = result;
        this.failure = failure;
        this.done = true;
        this.circuit.close();
        if (this.asyncCompletionListener != null) {
            (this.completionExecutor == null ? this.executor : this.completionExecutor).submit(Callables.of(this.asyncCompletionListener, result, failure));
        }
        if (failure == null) {
            if (this.asyncSuccessListener != null) {
                (this.successExecutor == null ? this.executor : this.successExecutor).submit(Callables.of(this.asyncSuccessListener, result));
            }
        } else if (this.asyncFailureListener != null) {
            (this.failureExecutor == null ? this.executor : this.failureExecutor).submit(Callables.of(this.asyncFailureListener, failure));
        }
        if (this.completionListener != null) {
            this.completionListener.onCompletion(result, failure);
        }
        if (failure == null) {
            if (this.successListener != null) {
                this.successListener.onSuccess(result);
            }
        } else if (this.failureListener != null) {
            this.failureListener.onFailure(failure);
        }
    }

    void setFuture(Future<T> delegate) {
        this.delegate = delegate;
    }
}

