/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.RecurrentFuture;

abstract class AsyncCallable<T>
implements Callable<T> {
    protected Invocation invocation;
    protected RecurrentFuture<T> future;
    protected ScheduledExecutorService executor;

    AsyncCallable() {
    }

    static <T> AsyncCallable<T> of(final Callable<T> callable) {
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object result = callable.call();
                    this.recordResult(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.recordResult(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallable<T> of(final ContextualCallable<T> callable) {
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object result = callable.call(this.invocation);
                    this.recordResult(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.recordResult(null, e);
                    return null;
                }
            }
        };
    }

    static AsyncCallable<?> of(final ContextualRunnable runnable) {
        return new AsyncCallable<Object>(){

            @Override
            public Void call() throws Exception {
                try {
                    runnable.run(this.invocation);
                    this.recordResult(null, null);
                }
                catch (Exception e) {
                    this.recordResult(null, e);
                }
                return null;
            }
        };
    }

    static AsyncCallable<?> of(final Runnable runnable) {
        return new AsyncCallable<Object>(){

            @Override
            public Void call() throws Exception {
                try {
                    runnable.run();
                    this.recordResult(null, null);
                }
                catch (Exception e) {
                    this.recordResult(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> ofFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    ((CompletableFuture)callable.call(this.invocation)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            this.recordResult(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.recordResult(null, e);
                }
                return null;
            }
        };
    }

    void initialize(Invocation invocation, RecurrentFuture<T> future, ScheduledExecutorService executor) {
        this.invocation = invocation;
        this.future = future;
        this.executor = executor;
    }

    void recordResult(T result, Throwable failure) {
        if (this.invocation.retryRequested) {
            this.invocation.reset();
            this.invocation.adjustForMaxDuration();
            this.scheduleRetry();
        } else if (this.invocation.completionRequested) {
            this.future.complete(this.invocation.result, this.invocation.failure);
            this.invocation.reset();
        } else if (failure != null) {
            if (this.invocation.canRetryOn(failure)) {
                this.scheduleRetry();
            } else {
                this.future.complete(null, failure);
            }
        } else {
            this.future.complete(result, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleRetry() {
        RecurrentFuture<T> recurrentFuture = this.future;
        synchronized (recurrentFuture) {
            if (!this.future.isDone() && !this.future.isCancelled()) {
                this.future.setFuture(this.executor.schedule(this, this.invocation.waitTime, TimeUnit.NANOSECONDS));
            }
        }
    }
}

