/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.RetryStats;
import net.jodah.recurrent.internal.util.Assert;

public class Invocation
extends RetryStats {
    volatile boolean retryRequested;
    volatile boolean completionRequested;
    volatile Object result;
    volatile Throwable failure;

    public Invocation(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    public void complete() {
        this.complete(null);
    }

    public void complete(Object result) {
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.result = result;
    }

    public void completeExceptionally(Throwable failure) {
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.failure = failure;
    }

    public boolean retry() {
        return this.retryInternal(null);
    }

    public boolean retry(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryInternal(failure);
    }

    void reset() {
        this.retryRequested = false;
        this.completionRequested = false;
        this.result = null;
        this.failure = null;
    }

    private boolean retryInternal(Throwable failure) {
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        if (this.canRetryOn(failure)) {
            this.retryRequested = true;
            return true;
        }
        if (failure == null) {
            failure = new RuntimeException("Retry invocations exceeded");
        }
        this.completeExceptionally(failure);
        return false;
    }
}

