/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.Duration;
import net.jodah.recurrent.util.Predicate;

public final class RetryPolicy {
    private Duration delay = Duration.NONE;
    private double delayMultiplier;
    private Duration maxDelay;
    private Duration maxDuration;
    private int maxRetries = -1;
    private Class<? extends Throwable>[] retryOn;
    private Predicate<Throwable> retryPredicate;

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.length <= 0L);
    }

    public boolean allowsRetriesFor(Throwable failure) {
        boolean allowsRetries = this.allowsRetries();
        if (!allowsRetries) {
            return false;
        }
        if (this.retryPredicate != null) {
            return this.retryPredicate.test(failure);
        }
        if (this.retryOn != null) {
            for (Class<? extends Throwable> retryType : this.retryOn) {
                if (!failure.getClass().isAssignableFrom(retryType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        this.retryOn = failures;
        return this;
    }

    public RetryPolicy retryWhen(Predicate<? extends Throwable> retryPredicate) {
        Assert.notNull(retryPredicate, "retryPredicate");
        this.retryPredicate = retryPredicate;
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayMultiplier) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayMultiplier = delayMultiplier;
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater tha 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "The delay must be less than the maxDuration", new Object[0]);
        }
        Assert.isTrue(this.delay.toNanos() < this.maxDelay.toNanos(), "The delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayMultiplier > 1.0, "The delayMultiplier must be greater than 1", new Object[0]);
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater tha 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "The delay must be less than the maxDuration", new Object[0]);
        }
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.maxDuration = new Duration(maxDuration, timeUnit);
        Assert.state(this.maxDuration.toNanos() > this.delay.toNanos(), "The maxDuration must be greater than the delay", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "The maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }
}

