/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import net.jodah.recurrent.RetryPolicy;

public class RetryStats {
    final RetryPolicy retryPolicy;
    private final long startTime;
    volatile int retryCount;
    volatile long waitTime;

    public RetryStats(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        this.waitTime = retryPolicy.getDelay().toNanos();
        this.startTime = System.nanoTime();
    }

    public boolean canRetry() {
        return this.canRetryOn(null);
    }

    public boolean canRetryOn(Throwable failure) {
        if (failure == null && !this.retryPolicy.allowsRetries() || !this.retryPolicy.allowsRetriesFor(failure)) {
            return false;
        }
        ++this.retryCount;
        this.adjustForBackoffs();
        this.adjustForMaxDuration();
        return !this.isPolicyExceeded();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    void adjustForBackoffs() {
        if (this.retryPolicy.getMaxDelay() != null) {
            this.waitTime = (long)Math.min((double)this.waitTime * this.retryPolicy.getDelayMultiplier(), (double)this.retryPolicy.getMaxDelay().toNanos());
        }
    }

    void adjustForMaxDuration() {
        if (this.retryPolicy.getMaxDuration() != null) {
            long elapsedNanos = System.nanoTime() - this.startTime;
            long maxRemainingWaitTime = this.retryPolicy.getMaxDuration().toNanos() - elapsedNanos;
            this.waitTime = Math.min(this.waitTime, maxRemainingWaitTime < 0L ? 0L : maxRemainingWaitTime);
            if (this.waitTime < 0L) {
                this.waitTime = 0L;
            }
        }
    }

    boolean isPolicyExceeded() {
        boolean withinMaxRetries = this.retryPolicy.getMaxRetries() == -1 || this.retryCount <= this.retryPolicy.getMaxRetries();
        boolean withinMaxDuration = this.retryPolicy.getMaxDuration() == null || System.nanoTime() - this.startTime < this.retryPolicy.getMaxDuration().toNanos();
        return !withinMaxRetries || !withinMaxDuration;
    }
}

