/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.event.CompletionListener;

public final class Recurrent {
    private Recurrent() {
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.future(Recurrent.contextual(callable), retryPolicy, executor);
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        final CompletableFuture response = new CompletableFuture();
        RecurrentFuture future = new RecurrentFuture(executor).whenComplete(new CompletionListener<T>(){

            @Override
            public void onCompletion(T result, Throwable failure) {
                if (failure == null) {
                    response.complete(result);
                } else {
                    response.completeExceptionally(failure);
                }
            }
        });
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, executor, future);
        return response;
    }

    public static <T> T get(Callable<T> callable, RetryPolicy retryPolicy) {
        return Recurrent.call(callable, retryPolicy);
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, executor, null);
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, executor, null);
    }

    public static RecurrentFuture<?> run(ContextualRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, executor, null);
    }

    public static void run(Runnable runnable, RetryPolicy retryPolicy) {
        Recurrent.call(Callables.of(runnable), retryPolicy);
    }

    public static RecurrentFuture<?> run(Runnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, executor, null);
    }

    private static <T> RecurrentFuture<T> call(AsyncCallable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor, RecurrentFuture<T> future) {
        if (future == null) {
            future = new RecurrentFuture(executor);
        }
        callable.initialize(new Invocation(retryPolicy), future, executor);
        future.setFuture(executor.submit(callable));
        return future;
    }

    private static <T> T call(Callable<T> callable, RetryPolicy retryPolicy) {
        Throwable failure;
        Invocation invocation = new Invocation(retryPolicy);
        T result = null;
        while (true) {
            try {
                failure = null;
                result = callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            if (!invocation.canRetryWhen(result, failure)) break;
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(invocation.waitTime));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (failure == null) {
            return result;
        }
        RuntimeException re = failure instanceof RuntimeException ? (RuntimeException)failure : new RuntimeException(failure);
        throw re;
    }

    private static <T> ContextualCallable<T> contextual(final Callable<T> callable) {
        return new ContextualCallable<T>(){

            @Override
            public T call(Invocation invocation) throws Exception {
                return callable.call();
            }
        };
    }
}

