/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.jodah.recurrent.AsyncInvocation;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;

abstract class AsyncCallable<T>
implements Callable<T> {
    protected AsyncInvocation invocation;

    AsyncCallable() {
    }

    static <T> AsyncCallable<T> of(final Callable<T> callable) {
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object result = callable.call();
                    this.invocation.retryOrComplete(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallable<T> of(final ContextualCallable<T> callable) {
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.invocation.reset();
                    return callable.call(this.invocation);
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                    return null;
                }
            }
        };
    }

    static AsyncCallable<?> of(final ContextualRunnable runnable) {
        return new AsyncCallable<Object>(){

            @Override
            public synchronized Void call() throws Exception {
                try {
                    this.invocation.reset();
                    runnable.run(this.invocation);
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                }
                return null;
            }
        };
    }

    static AsyncCallable<?> of(final Runnable runnable) {
        return new AsyncCallable<Object>(){

            @Override
            public Void call() throws Exception {
                try {
                    runnable.run();
                    this.invocation.retryOrComplete(null, null);
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> ofFuture(final Callable<CompletableFuture<T>> callable) {
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    ((CompletableFuture)callable.call()).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            invocation.retryOrComplete(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> ofFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.invocation.reset();
                    ((CompletableFuture)callable.call(this.invocation)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null) {
                                invocation.retryOrComplete(innerResult, failure);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.invocation.retryOrComplete(null, e);
                }
                return null;
            }
        };
    }

    void initialize(AsyncInvocation invocation) {
        this.invocation = invocation;
    }
}

