/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.Scheduler;
import net.jodah.recurrent.internal.util.Assert;

public class AsyncInvocation
extends Invocation {
    private final AsyncCallable<Object> callable;
    private final RecurrentFuture<Object> future;
    private final Scheduler scheduler;
    volatile boolean retried;

    <T> AsyncInvocation(AsyncCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, RecurrentFuture<T> future) {
        super(retryPolicy);
        this.callable = callable;
        this.scheduler = scheduler;
        this.future = future;
    }

    @Override
    public void complete() {
        this.completeInternal(null, null, false);
    }

    @Override
    public boolean complete(Object result) {
        return this.completeInternal(result, null, true);
    }

    public boolean complete(Object result, Throwable failure) {
        return this.completeInternal(result, failure, true);
    }

    public boolean retry() {
        return this.retryInternal(this.lastResult, this.lastFailure);
    }

    public boolean retryFor(Object result) {
        return this.retryInternal(result, null);
    }

    public boolean retryFor(Object result, Throwable failure) {
        return this.retryInternal(result, failure);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryInternal(null, failure);
    }

    void reset() {
        this.retried = false;
    }

    void retryOrComplete(Object result, Throwable failure) {
        if (!this.retry(result, failure)) {
            this.future.complete(result, failure);
        }
    }

    private boolean completeInternal(Object result, Throwable failure, boolean checkArgs) {
        boolean complete = super.complete(result, failure, checkArgs);
        if (complete) {
            this.future.complete(result, failure);
        }
        return complete;
    }

    private boolean retry(Object result, Throwable failure) {
        boolean canRetry = this.canRetryFor(result, failure);
        if (canRetry && !this.future.isDone() && !this.future.isCancelled()) {
            this.future.setFuture(this.scheduler.schedule(this.callable, this.waitTime, TimeUnit.NANOSECONDS));
        }
        return canRetry;
    }

    private boolean retryInternal(Object result, Throwable failure) {
        Assert.state(!this.retried, "Retry has already been called", new Object[0]);
        this.retried = true;
        boolean retrying = this.retry(result, failure);
        if (!retrying) {
            this.future.complete(result, failure);
        }
        return retrying;
    }
}

