/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.internal.util.Assert;

public class Invocation {
    final RetryPolicy retryPolicy;
    private final long startTime;
    protected volatile Object lastResult;
    protected volatile Throwable lastFailure;
    protected volatile boolean completed;
    volatile int attempts;
    volatile long waitTime;

    public Invocation(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        this.waitTime = retryPolicy.getDelay().toNanos();
        this.startTime = System.nanoTime();
    }

    public boolean canRetryFor(Object result) {
        return this.canRetryFor(result, null);
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        this.lastResult = result;
        this.lastFailure = failure;
        if (this.complete(result, failure, true)) {
            return false;
        }
        this.incrementAttempts();
        this.completed = this.isPolicyExceeded();
        return !this.completed;
    }

    public boolean canRetryOn(Throwable failure) {
        return this.canRetryFor(null, failure);
    }

    public void complete() {
        this.complete(null, null, false);
    }

    public boolean complete(Object result) {
        return this.complete(result, null, true);
    }

    public int getAttemptCount() {
        return this.attempts;
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public boolean recordFailure(Throwable failure) {
        return this.canRetryFor(null, failure);
    }

    boolean complete(Object result, Throwable failure, boolean checkArgs) {
        Assert.state(!this.completed, "Invocation has already been completed", new Object[0]);
        this.lastResult = result;
        this.lastFailure = failure;
        if (checkArgs && this.retryPolicy.allowsRetriesFor(result, failure)) {
            return false;
        }
        this.incrementAttempts();
        this.completed = true;
        return true;
    }

    private void adjustForBackoffs() {
        if (this.retryPolicy.getMaxDelay() != null) {
            this.waitTime = (long)Math.min((double)this.waitTime * this.retryPolicy.getDelayMultiplier(), (double)this.retryPolicy.getMaxDelay().toNanos());
        }
    }

    private void adjustForMaxDuration() {
        if (this.retryPolicy.getMaxDuration() != null) {
            long elapsedNanos = System.nanoTime() - this.startTime;
            long maxRemainingWaitTime = this.retryPolicy.getMaxDuration().toNanos() - elapsedNanos;
            this.waitTime = Math.min(this.waitTime, maxRemainingWaitTime < 0L ? 0L : maxRemainingWaitTime);
            if (this.waitTime < 0L) {
                this.waitTime = 0L;
            }
        }
    }

    private void incrementAttempts() {
        ++this.attempts;
        this.adjustForBackoffs();
        this.adjustForMaxDuration();
    }

    private boolean isPolicyExceeded() {
        boolean withinMaxRetries = this.retryPolicy.getMaxRetries() == -1 || this.attempts <= this.retryPolicy.getMaxRetries();
        boolean withinMaxDuration = this.retryPolicy.getMaxDuration() == null || System.nanoTime() - this.startTime < this.retryPolicy.getMaxDuration().toNanos();
        return !withinMaxRetries || !withinMaxDuration;
    }
}

