/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.AsyncInvocation;
import net.jodah.recurrent.AsyncListeners;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.Listeners;
import net.jodah.recurrent.RecurrentException;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.Scheduler;
import net.jodah.recurrent.Schedulers;
import net.jodah.recurrent.internal.util.Assert;

public class Recurrent {
    Recurrent() {
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor));
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor), listeners);
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler, null), null);
        return response;
    }

    public static <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        Assert.notNull(listeners, "listeners");
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler, listeners), listeners);
        return response;
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor));
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.future(callable, retryPolicy, Schedulers.of(executor), listeners);
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler, null), null);
        return response;
    }

    public static <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        Assert.notNull(listeners, "listeners");
        CompletableFuture response = new CompletableFuture();
        Recurrent.call(AsyncCallable.ofFuture(callable), retryPolicy, scheduler, RecurrentFuture.of(response, scheduler, listeners), listeners);
        return response;
    }

    public static <T> T get(Callable<T> callable, RetryPolicy retryPolicy) {
        return Recurrent.call(callable, retryPolicy, null);
    }

    public static <T> T get(Callable<T> callable, RetryPolicy retryPolicy, Listeners<T> listeners) {
        return Recurrent.call(callable, retryPolicy, Assert.notNull(listeners, "listeners"));
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null, null);
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null, Assert.notNull(listeners, "listeners"));
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null, null);
    }

    public static <T> RecurrentFuture<T> get(Callable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null, Assert.notNull(listeners, "listeners"));
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null, null);
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, Schedulers.of(executor), null, Assert.notNull(listeners, "listeners"));
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null, null);
    }

    public static <T> RecurrentFuture<T> get(ContextualCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(callable), retryPolicy, scheduler, null, Assert.notNull(listeners, "listeners"));
    }

    public static RecurrentFuture<?> run(ContextualRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null, null);
    }

    public static <T> RecurrentFuture<T> run(ContextualRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null, Assert.notNull(listeners, "listeners"));
    }

    public static RecurrentFuture<?> run(ContextualRunnable runnable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null, null);
    }

    public static <T> RecurrentFuture<T> run(ContextualRunnable runnable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null, Assert.notNull(listeners, "listeners"));
    }

    public static void run(CheckedRunnable runnable, RetryPolicy retryPolicy) {
        Recurrent.call(Callables.of(runnable), retryPolicy, null);
    }

    public static void run(CheckedRunnable runnable, RetryPolicy retryPolicy, Listeners<?> listeners) {
        Recurrent.call(Callables.of(runnable), retryPolicy, Assert.notNull(listeners, "listeners"));
    }

    public static RecurrentFuture<?> run(CheckedRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null, null);
    }

    public static <T> RecurrentFuture<T> run(CheckedRunnable runnable, RetryPolicy retryPolicy, ScheduledExecutorService executor, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, Schedulers.of(executor), null, Assert.notNull(listeners, "listeners"));
    }

    public static RecurrentFuture<?> run(CheckedRunnable runnable, RetryPolicy retryPolicy, Scheduler scheduler) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null, null);
    }

    public static <T> RecurrentFuture<T> run(CheckedRunnable runnable, RetryPolicy retryPolicy, Scheduler scheduler, AsyncListeners<T> listeners) {
        return Recurrent.call(AsyncCallable.of(runnable), retryPolicy, scheduler, null, Assert.notNull(listeners, "listeners"));
    }

    private static <T> RecurrentFuture<T> call(AsyncCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, RecurrentFuture<T> future, AsyncListeners<T> listeners) {
        Assert.notNull(callable, "callable");
        Assert.notNull(retryPolicy, "retryPolicy");
        Assert.notNull(scheduler, "scheduler");
        if (future == null) {
            future = new RecurrentFuture<T>(scheduler, listeners);
        }
        AsyncInvocation invocation = new AsyncInvocation(callable, retryPolicy, scheduler, future, listeners);
        future.initialize(invocation);
        callable.initialize(invocation);
        future.setFuture(scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
        return future;
    }

    private static <T> T call(Callable<T> callable, RetryPolicy retryPolicy, Listeners<T> listeners) {
        boolean success;
        Throwable failure;
        boolean shouldRetry;
        boolean completed;
        Assert.notNull(callable, "callable");
        Assert.notNull(retryPolicy, "retryPolicy");
        Invocation invocation = new Invocation(retryPolicy);
        Object result = null;
        do {
            try {
                failure = null;
                result = callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            completed = invocation.complete(result, failure, true);
            success = completed && failure == null;
            boolean bl = shouldRetry = completed ? false : invocation.canRetryForInternal(result, failure);
            if (!success && listeners != null) {
                listeners.handleFailedAttempt(result, failure, invocation);
            }
            if (!shouldRetry) continue;
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(invocation.waitTime));
            }
            catch (InterruptedException e) {
                throw new RecurrentException(e);
            }
            if (listeners == null) continue;
            listeners.handleRetry(result, failure, invocation);
        } while (!completed && shouldRetry);
        if (listeners != null) {
            listeners.complete(result, failure, invocation, success);
        }
        if (success || failure == null) {
            return result;
        }
        RecurrentException re = failure instanceof RecurrentException ? (RecurrentException)failure : new RecurrentException(failure);
        throw re;
    }
}

