/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.BiPredicate;
import net.jodah.recurrent.util.Duration;
import net.jodah.recurrent.util.Predicate;

public final class RetryPolicy {
    private static final Object DEFAULT_RESULT_VALUE = new Object();
    private Duration delay;
    private double delayMultiplier;
    private Duration maxDelay;
    private Duration maxDuration;
    private int maxRetries;
    private List<Class<? extends Throwable>> failureTypes;
    private Predicate<Throwable> failurePredicate;
    private Object resultValue = DEFAULT_RESULT_VALUE;
    private Predicate<Object> resultPredicate;
    private BiPredicate<Object, Throwable> completionPredicate;

    public RetryPolicy() {
        this.delay = Duration.NONE;
        this.maxRetries = -1;
    }

    public RetryPolicy(RetryPolicy rp) {
        this.delay = rp.delay;
        this.delayMultiplier = rp.delayMultiplier;
        this.maxDelay = rp.maxDelay;
        this.maxDuration = rp.maxDuration;
        this.maxRetries = rp.maxRetries;
        this.failureTypes = rp.failureTypes;
        this.resultValue = rp.resultValue;
        this.failurePredicate = rp.failurePredicate;
        this.resultPredicate = rp.resultPredicate;
        this.completionPredicate = rp.completionPredicate;
    }

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.length <= 0L);
    }

    public boolean allowsRetriesFor(Object result, Throwable failure) {
        if (!this.allowsRetries()) {
            return false;
        }
        if (this.completionPredicate != null && this.completionPredicate.test(result, failure)) {
            return true;
        }
        if (failure != null) {
            if (this.failurePredicate != null && this.failurePredicate.test(failure)) {
                return true;
            }
            if (this.failureTypes != null) {
                for (Class<? extends Throwable> failureType : this.failureTypes) {
                    if (!failure.getClass().isAssignableFrom(failureType)) continue;
                    return true;
                }
            }
            return this.completionPredicate == null && this.failurePredicate == null && this.failureTypes == null;
        }
        if (this.resultPredicate != null && this.resultPredicate.test(result)) {
            return true;
        }
        if (!DEFAULT_RESULT_VALUE.equals(this.resultValue)) {
            return this.resultValue == null ? result == null : this.resultValue.equals(result);
        }
        return false;
    }

    public RetryPolicy copy() {
        return new RetryPolicy(this);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayMultiplier() {
        return this.delayMultiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RetryPolicy retryOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        this.failureTypes = Arrays.asList(failures);
        return this;
    }

    public RetryPolicy retryOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "Failures cannot be empty", new Object[0]);
        this.failureTypes = failures;
        return this;
    }

    public RetryPolicy retryOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        this.failurePredicate = failurePredicate;
        return this;
    }

    public <T> RetryPolicy retryWhen(BiPredicate<T, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        this.completionPredicate = completionPredicate;
        return this;
    }

    public <T> RetryPolicy retryWhen(Predicate<T> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.resultPredicate = resultPredicate;
        return this;
    }

    public RetryPolicy retryFor(Object result) {
        this.resultValue = result;
        return this;
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit) {
        return this.withBackoff(delay, maxDelay, timeUnit, 2.0);
    }

    public RetryPolicy withBackoff(long delay, long maxDelay, TimeUnit timeUnit, double delayMultiplier) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        this.maxDelay = new Duration(maxDelay, timeUnit);
        this.delayMultiplier = delayMultiplier;
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater tha 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "The delay must be less than the maxDuration", new Object[0]);
        }
        Assert.isTrue(this.delay.toNanos() < this.maxDelay.toNanos(), "The delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayMultiplier > 1.0, "The delayMultiplier must be greater than 1", new Object[0]);
        return this;
    }

    public RetryPolicy withDelay(long delay, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.delay = new Duration(delay, timeUnit);
        Assert.isTrue(this.delay.toNanos() > 0L, "The delay must be greater tha 0", new Object[0]);
        if (this.maxDuration != null) {
            Assert.state(this.delay.toNanos() < this.maxDuration.toNanos(), "The delay must be less than the maxDuration", new Object[0]);
        }
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxDuration(long maxDuration, TimeUnit timeUnit) {
        Assert.notNull(timeUnit, "timeUnit");
        this.maxDuration = new Duration(maxDuration, timeUnit);
        Assert.state(this.maxDuration.toNanos() > this.delay.toNanos(), "The maxDuration must be greater than the delay", new Object[0]);
        return this;
    }

    public RetryPolicy withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "The maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }
}

