/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.jodah.recurrent.AsyncInvocation;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.internal.util.Assert;

abstract class AsyncCallable<T>
implements Callable<T> {
    protected AsyncInvocation invocation;

    AsyncCallable() {
    }

    static <T> AsyncCallable<T> of(final Callable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.invocation.reset();
                    Object result = callable.call();
                    this.invocation.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallable<T> of(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.invocation.reset();
                    return callable.call(this.invocation);
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncCallable<T> of(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.invocation.reset();
                    runnable.run(this.invocation);
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> of(final Runnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.invocation.reset();
                    runnable.run();
                    this.invocation.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> of(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.invocation.reset();
                    runnable.run();
                    this.invocation.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> ofFuture(final Callable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.invocation.reset();
                    ((CompletableFuture)callable.call()).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            invocation.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncCallable<T> ofFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.invocation.reset();
                    ((CompletableFuture)callable.call(this.invocation)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null) {
                                invocation.completeOrRetry(innerResult, failure);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.invocation.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    void initialize(AsyncInvocation invocation) {
        this.invocation = invocation;
    }
}

