/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.AsyncListeners;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.concurrent.Scheduler;

public class AsyncInvocation
extends Invocation {
    private final AsyncCallable<Object> callable;
    private final RecurrentFuture<Object> future;
    private final AsyncListeners<Object> listeners;
    private final Scheduler scheduler;
    volatile boolean completeCalled;
    volatile boolean retryCalled;

    <T> AsyncInvocation(AsyncCallable<T> callable, RetryPolicy retryPolicy, Scheduler scheduler, RecurrentFuture<T> future, AsyncListeners<T> listeners) {
        super(retryPolicy);
        this.callable = callable;
        this.scheduler = scheduler;
        this.future = future;
        this.listeners = listeners;
    }

    @Override
    public void complete() {
        this.completeInternal(null, null, false);
    }

    @Override
    public boolean complete(Object result) {
        return this.completeInternal(result, null, true);
    }

    public boolean complete(Object result, Throwable failure) {
        return this.completeInternal(result, failure, true);
    }

    public boolean retry() {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(this.lastResult, this.lastFailure);
    }

    public boolean retryFor(Object result) {
        return this.retryFor(result, null);
    }

    public boolean retryFor(Object result, Throwable failure) {
        Assert.state(!this.retryCalled, "Retry has already been called", new Object[0]);
        this.retryCalled = true;
        return this.completeOrRetry(result, failure);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryFor(null, failure);
    }

    void reset() {
        this.completeCalled = false;
        this.retryCalled = false;
    }

    private boolean completeInternal(Object result, Throwable failure, boolean checkArgs) {
        boolean success;
        boolean completed = super.complete(result, failure, checkArgs);
        boolean bl = success = completed && failure == null;
        if (!success && !this.completeCalled && this.listeners != null) {
            this.listeners.handleFailedAttempt(result, failure, this, this.scheduler);
        }
        if (completed) {
            this.future.complete(result, failure, success);
        }
        this.completeCalled = true;
        return completed;
    }

    boolean completeOrRetry(Object result, Throwable failure) {
        boolean shouldRetry;
        boolean success;
        boolean completed = super.complete(result, failure, true);
        boolean bl = success = completed && failure == null;
        boolean bl2 = completed ? false : (shouldRetry = this.canRetryForInternal(result, failure) && !this.future.isDone() && !this.future.isCancelled());
        if (!success && !this.completeCalled && this.listeners != null) {
            this.listeners.handleFailedAttempt(result, failure, this, this.scheduler);
        }
        if (shouldRetry) {
            if (this.listeners != null) {
                this.listeners.handleRetry(result, failure, this, this.scheduler);
            }
            this.future.setFuture(this.scheduler.schedule(this.callable, this.waitTime, TimeUnit.NANOSECONDS));
        }
        if (completed || !shouldRetry) {
            this.future.complete(result, failure, success);
        }
        this.completeCalled = true;
        return shouldRetry;
    }
}

