/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.InvocationStats;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.internal.util.Assert;

public class Invocation
implements InvocationStats {
    final RetryPolicy retryPolicy;
    private final long startTime;
    protected volatile Object lastResult;
    protected volatile Throwable lastFailure;
    protected volatile boolean completed;
    volatile int attempts;
    volatile long waitTime;

    public Invocation(RetryPolicy retryPolicy) {
        this.retryPolicy = Assert.notNull(retryPolicy, "retryPolicy");
        this.startTime = System.nanoTime();
        this.waitTime = retryPolicy.getDelay().toNanos();
    }

    public boolean canRetryFor(Object result) {
        return this.canRetryFor(result, null);
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        if (this.complete(result, failure, true)) {
            return false;
        }
        return this.canRetryForInternal(result, failure);
    }

    public boolean canRetryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.canRetryFor(null, failure);
    }

    public void complete() {
        this.complete(null, null, false);
    }

    public boolean complete(Object result) {
        return this.complete(result, null, true);
    }

    @Override
    public int getAttemptCount() {
        return this.attempts;
    }

    @Override
    public long getElapsedMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
    }

    @Override
    public long getElapsedNanos() {
        return System.nanoTime() - this.startTime;
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    @Override
    public long getStartMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.startTime);
    }

    @Override
    public long getStartNanos() {
        return this.startTime;
    }

    public long getWaitMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.waitTime);
    }

    public long getWaitNanos() {
        return this.waitTime;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public boolean recordFailure(Throwable failure) {
        return this.canRetryFor(null, failure);
    }

    boolean canRetryForInternal(Object result, Throwable failure) {
        this.lastResult = result;
        this.lastFailure = failure;
        this.incrementAttempts();
        this.completed = this.isPolicyExceeded();
        return !this.completed;
    }

    boolean complete(Object result, Throwable failure, boolean checkArgs) {
        Assert.state(!this.completed, "Invocation has already been completed", new Object[0]);
        this.lastResult = result;
        this.lastFailure = failure;
        if (checkArgs && this.retryPolicy.allowsRetriesFor(result, failure)) {
            return false;
        }
        this.incrementAttempts();
        this.completed = true;
        return true;
    }

    private void adjustForBackoffs() {
        if (this.retryPolicy.getMaxDelay() != null) {
            this.waitTime = (long)Math.min((double)this.waitTime * this.retryPolicy.getDelayMultiplier(), (double)this.retryPolicy.getMaxDelay().toNanos());
        }
    }

    private void adjustForMaxDuration() {
        if (this.retryPolicy.getMaxDuration() != null) {
            long elapsedNanos = this.getElapsedNanos();
            long maxRemainingWaitTime = this.retryPolicy.getMaxDuration().toNanos() - elapsedNanos;
            this.waitTime = Math.min(this.waitTime, maxRemainingWaitTime < 0L ? 0L : maxRemainingWaitTime);
            if (this.waitTime < 0L) {
                this.waitTime = 0L;
            }
        }
    }

    private void incrementAttempts() {
        ++this.attempts;
        this.adjustForBackoffs();
        this.adjustForMaxDuration();
    }

    private boolean isPolicyExceeded() {
        boolean withinMaxRetries = this.retryPolicy.getMaxRetries() == -1 || this.attempts <= this.retryPolicy.getMaxRetries();
        boolean withinMaxDuration = this.retryPolicy.getMaxDuration() == null || System.nanoTime() - this.startTime < this.retryPolicy.getMaxDuration().toNanos();
        return !withinMaxRetries || !withinMaxDuration;
    }
}

