/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;

public class InvocationStats {
    final long startTime;
    volatile int attempts;

    InvocationStats(long startTime) {
        this.startTime = startTime;
    }

    InvocationStats(InvocationStats stats) {
        this.startTime = stats.startTime;
        this.attempts = stats.attempts;
    }

    public int getAttemptCount() {
        return this.attempts;
    }

    public long getElapsedMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
    }

    public long getElapsedNanos() {
        return System.nanoTime() - this.startTime;
    }

    public long getStartMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.startTime);
    }

    public long getStartNanos() {
        return this.startTime;
    }

    InvocationStats copy() {
        return new InvocationStats(this);
    }
}

