/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import net.jodah.recurrent.InvocationStats;
import net.jodah.recurrent.event.ContextualResultListener;
import net.jodah.recurrent.event.ContextualSuccessListener;
import net.jodah.recurrent.event.ResultListener;
import net.jodah.recurrent.event.SuccessListener;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.concurrent.Scheduler;

public class Listeners<T> {
    private volatile ResultListener<T, Throwable> completeListener;
    private volatile ContextualResultListener<T, Throwable> ctxCompleteListener;
    private volatile ResultListener<T, Throwable> failedAttemptListener;
    private volatile ContextualResultListener<T, Throwable> ctxFailedAttemptListener;
    private volatile ResultListener<T, Throwable> failureListener;
    private volatile ContextualResultListener<T, Throwable> ctxFailureListener;
    private volatile ResultListener<T, Throwable> retryListener;
    private volatile ContextualResultListener<T, Throwable> ctxRetryListener;
    private volatile SuccessListener<T> successListener;
    private volatile ContextualSuccessListener<T> ctxSuccessListener;

    static <T> ContextualResultListener<T, Throwable> resultListenerOf(final ContextualSuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ContextualResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure, InvocationStats stats) {
                listener.onSuccess(result, stats);
            }
        };
    }

    static <T> ResultListener<T, Throwable> resultListenerOf(final SuccessListener<T> listener) {
        Assert.notNull(listener, "listener");
        return new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                listener.onSuccess(result);
            }
        };
    }

    public void onComplete(T result, Throwable failure) {
        if (this.completeListener != null) {
            this.completeListener.onResult(result, failure);
        }
    }

    public void onComplete(T result, Throwable failure, InvocationStats stats) {
        if (this.ctxCompleteListener != null) {
            this.ctxCompleteListener.onResult(result, failure, stats);
        }
    }

    public void onFailedAttempt(T result, Throwable failure) {
        if (this.failedAttemptListener != null) {
            this.failedAttemptListener.onResult(result, failure);
        }
    }

    public void onFailedAttempt(T result, Throwable failure, InvocationStats stats) {
        if (this.ctxFailedAttemptListener != null) {
            this.ctxFailedAttemptListener.onResult(result, failure, stats);
        }
    }

    public void onFailure(T result, Throwable failure) {
        if (this.failureListener != null) {
            this.failureListener.onResult(result, failure);
        }
    }

    public void onFailure(T result, Throwable failure, InvocationStats stats) {
        if (this.ctxFailureListener != null) {
            this.ctxFailureListener.onResult(result, failure, stats);
        }
    }

    public void onRetry(T result, Throwable failure) {
        if (this.retryListener != null) {
            this.retryListener.onResult(result, failure);
        }
    }

    public void onRetry(T result, Throwable failure, InvocationStats stats) {
        if (this.ctxRetryListener != null) {
            this.ctxRetryListener.onResult(result, failure, stats);
        }
    }

    public void onSuccess(T result) {
        if (this.successListener != null) {
            this.successListener.onSuccess(result);
        }
    }

    public void onSuccess(T result, InvocationStats stats) {
        if (this.ctxSuccessListener != null) {
            this.ctxSuccessListener.onSuccess(result, stats);
        }
    }

    public <L extends Listeners<T>> L whenComplete(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxCompleteListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenComplete(ResultListener<? super T, ? extends Throwable> listener) {
        this.completeListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenFailedAttempt(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxFailedAttemptListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenFailedAttempt(ResultListener<? super T, ? extends Throwable> listener) {
        this.failedAttemptListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenFailure(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxFailureListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenFailure(ResultListener<? super T, ? extends Throwable> listener) {
        this.failureListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenRetry(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.ctxRetryListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenRetry(ResultListener<? super T, ? extends Throwable> listener) {
        this.retryListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public <L extends Listeners<T>> L whenSuccess(ContextualSuccessListener<? super T> listener) {
        this.ctxSuccessListener = Assert.notNull(listener, "listener");
        return (L)this;
    }

    public Listeners<T> whenSuccess(SuccessListener<? super T> listener) {
        this.successListener = Assert.notNull(listener, "listener");
        return this;
    }

    void complete(T result, Throwable failure, InvocationStats stats, boolean success) {
        if (success) {
            this.handleSuccess(result);
            this.handleSuccess(result, stats);
        } else {
            this.handleFailure(result, failure);
            this.handleFailure(result, failure, stats);
        }
        this.handleComplete(result, failure);
        this.handleComplete(result, failure, stats);
    }

    void handleComplete(T result, Throwable failure) {
        try {
            this.onComplete(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleComplete(T result, Throwable failure, InvocationStats stats) {
        try {
            this.onComplete(result, failure, stats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailedAttempt(T result, Throwable failure, InvocationStats stats, Scheduler scheduler) {
        try {
            this.onFailedAttempt(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onFailedAttempt(result, failure, stats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailure(T result, Throwable failure) {
        try {
            this.onFailure(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleFailure(T result, Throwable failure, InvocationStats stats) {
        try {
            this.onFailure(result, failure, stats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleRetry(T result, Throwable failure, InvocationStats stats, Scheduler scheduler) {
        try {
            this.onRetry(result, failure);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onRetry(result, failure, stats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleSuccess(T result) {
        try {
            this.onSuccess(result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void handleSuccess(T result, InvocationStats stats) {
        try {
            this.onSuccess(result, stats);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

