/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.AsyncContextualCallable;
import net.jodah.recurrent.AsyncInvocation;
import net.jodah.recurrent.AsyncRecurrent;
import net.jodah.recurrent.AsyncRunnable;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Invocation;
import net.jodah.recurrent.Listeners;
import net.jodah.recurrent.RecurrentException;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.SyncContextualCallable;
import net.jodah.recurrent.SyncRecurrent;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.concurrent.Scheduler;
import net.jodah.recurrent.util.concurrent.Schedulers;

public class Recurrent<T> {
    public static SyncRecurrent with(RetryPolicy retryPolicy) {
        return new SyncRecurrentInternal(retryPolicy);
    }

    public static AsyncRecurrent with(RetryPolicy retryPolicy, ScheduledExecutorService executor) {
        return new AsyncRecurrentInternal(retryPolicy, Schedulers.of(executor));
    }

    public static AsyncRecurrent with(RetryPolicy retryPolicy, Scheduler scheduler) {
        return new AsyncRecurrentInternal(retryPolicy, scheduler);
    }

    private static class SyncRecurrentInternal
    implements SyncRecurrent {
        private final RetryPolicy retryPolicy;
        private Listeners<?> listeners;

        private SyncRecurrentInternal(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
        }

        @Override
        public <T> T get(Callable<T> callable) {
            return this.call(Assert.notNull(callable, "callable"));
        }

        @Override
        public <T> T get(ContextualCallable<T> callable) {
            return this.call(SyncContextualCallable.of(callable));
        }

        @Override
        public void run(CheckedRunnable runnable) {
            this.call(Callables.of(runnable));
        }

        @Override
        public void run(ContextualRunnable runnable) {
            this.call(SyncContextualCallable.of(runnable));
        }

        @Override
        public SyncRecurrent with(Listeners<?> listeners) {
            this.listeners = Assert.notNull(listeners, "listeners");
            return this;
        }

        private <T> T call(Callable<T> callable) {
            boolean success;
            Throwable failure;
            boolean shouldRetry;
            boolean completed;
            Invocation invocation = new Invocation(this.retryPolicy);
            if (callable instanceof SyncContextualCallable) {
                ((SyncContextualCallable)callable).initialize(invocation);
            }
            Listeners<?> typedListeners = this.listeners;
            Object result = null;
            do {
                try {
                    failure = null;
                    result = callable.call();
                }
                catch (Throwable t) {
                    failure = t;
                }
                completed = invocation.complete(result, failure, true);
                success = completed && failure == null;
                boolean bl = shouldRetry = completed ? false : invocation.canRetryForInternal(result, failure);
                if (!success && typedListeners != null) {
                    typedListeners.handleFailedAttempt(result, failure, invocation, null);
                }
                if (!shouldRetry) continue;
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(invocation.waitTime));
                }
                catch (InterruptedException e) {
                    throw new RecurrentException(e);
                }
                if (typedListeners == null) continue;
                typedListeners.handleRetry(result, failure, invocation, null);
            } while (!completed && shouldRetry);
            if (typedListeners != null) {
                typedListeners.complete(result, failure, invocation, success);
            }
            if (success || failure == null) {
                return result;
            }
            RecurrentException re = failure instanceof RecurrentException ? (RecurrentException)failure : new RecurrentException(failure);
            throw re;
        }
    }

    private static class AsyncRecurrentInternal
    implements AsyncRecurrent {
        private final RetryPolicy retryPolicy;
        private final Scheduler scheduler;
        private Listeners<?> listeners;

        private AsyncRecurrentInternal(RetryPolicy retryPolicy, Scheduler scheduler) {
            this.retryPolicy = retryPolicy;
            this.scheduler = scheduler;
        }

        @Override
        public <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable) {
            CompletableFuture response = new CompletableFuture();
            this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
            return response;
        }

        @Override
        public <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable) {
            CompletableFuture response = new CompletableFuture();
            this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
            return response;
        }

        @Override
        public <T> CompletableFuture<T> futureAsync(AsyncCallable<CompletableFuture<T>> callable) {
            CompletableFuture response = new CompletableFuture();
            this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
            return response;
        }

        @Override
        public <T> RecurrentFuture<T> get(Callable<T> callable) {
            return this.call(AsyncContextualCallable.of(callable), null);
        }

        @Override
        public <T> RecurrentFuture<T> get(ContextualCallable<T> callable) {
            return this.call(AsyncContextualCallable.of(callable), null);
        }

        @Override
        public <T> RecurrentFuture<T> getAsync(AsyncCallable<T> callable) {
            return this.call(AsyncContextualCallable.of(callable), null);
        }

        @Override
        public RecurrentFuture<Void> run(CheckedRunnable runnable) {
            return this.call(AsyncContextualCallable.of(runnable), null);
        }

        @Override
        public RecurrentFuture<Void> run(ContextualRunnable runnable) {
            return this.call(AsyncContextualCallable.of(runnable), null);
        }

        @Override
        public RecurrentFuture<Void> runAsync(AsyncRunnable runnable) {
            return this.call(AsyncContextualCallable.of(runnable), null);
        }

        @Override
        public <T extends Listeners<?>> AsyncRecurrent with(T listeners) {
            this.listeners = Assert.notNull(listeners, "listeners");
            return this;
        }

        private <T> RecurrentFuture<T> call(AsyncContextualCallable<T> callable, RecurrentFuture<T> future) {
            Listeners<?> typedListeners = this.listeners;
            if (future == null) {
                future = new RecurrentFuture(this.scheduler, typedListeners);
            }
            AsyncInvocation invocation = new AsyncInvocation(callable, this.retryPolicy, this.scheduler, future, typedListeners);
            future.initialize(invocation);
            callable.initialize(invocation);
            future.setFuture(this.scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
            return future;
        }
    }
}

