/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.recurrent.AsyncListeners;
import net.jodah.recurrent.InvocationStats;
import net.jodah.recurrent.Listeners;
import net.jodah.recurrent.event.ContextualResultListener;
import net.jodah.recurrent.event.ContextualSuccessListener;
import net.jodah.recurrent.event.ResultListener;
import net.jodah.recurrent.event.SuccessListener;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.internal.util.concurrent.ReentrantCircuit;
import net.jodah.recurrent.util.concurrent.Scheduler;

public class RecurrentFuture<T>
implements Future<T> {
    private final ReentrantCircuit circuit = new ReentrantCircuit();
    private final Scheduler scheduler;
    private InvocationStats stats;
    private volatile Future<T> delegate;
    private volatile boolean done;
    private volatile boolean cancelled;
    private volatile boolean success;
    private volatile T result;
    private volatile Throwable failure;
    private final Listeners<T> listeners;
    private volatile AsyncListeners.AsyncResultListener<T> asyncCompleteListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxCompleteListener;
    private volatile AsyncListeners.AsyncResultListener<T> asyncFailureListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxFailureListener;
    private volatile AsyncListeners.AsyncResultListener<T> asyncSuccessListener;
    private volatile AsyncListeners.AsyncCtxResultListener<T> asyncCtxSuccessListener;

    RecurrentFuture(Scheduler scheduler, Listeners<T> listeners) {
        this.scheduler = scheduler;
        this.listeners = listeners == null ? new Listeners() : listeners;
        this.circuit.open();
    }

    static <T> RecurrentFuture<T> of(final CompletableFuture<T> future, Scheduler scheduler, Listeners<T> listeners) {
        Assert.notNull(future, "future");
        Assert.notNull(scheduler, "scheduler");
        return new RecurrentFuture<T>(scheduler, listeners).whenComplete(new ResultListener<T, Throwable>(){

            @Override
            public void onResult(T result, Throwable failure) {
                if (failure == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(failure);
                }
            }
        });
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = this.delegate.cancel(mayInterruptIfRunning);
        this.cancelled = true;
        this.circuit.close();
        return result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.circuit.await();
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.circuit.await(timeout, Assert.notNull(unit, "unit"))) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    public synchronized RecurrentFuture<T> whenComplete(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.whenComplete(listener);
        if (this.done) {
            this.listeners.handleComplete(this.result, this.failure, this.stats);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenComplete(ResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.whenComplete(listener);
        if (this.done) {
            this.listeners.handleComplete(this.result, this.failure);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenCompleteAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxCompleteListener = new AsyncListeners.AsyncCtxResultListener<T>(listener);
        this.call(this.done, this.asyncCtxCompleteListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenCompleteAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxCompleteListener = new AsyncListeners.AsyncCtxResultListener<T>(listener, executor);
        this.call(this.done, this.asyncCtxCompleteListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenCompleteAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCompleteListener = new AsyncListeners.AsyncResultListener<T>(listener);
        this.call(this.done, this.asyncCompleteListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenCompleteAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCompleteListener = new AsyncListeners.AsyncResultListener<T>(listener, executor);
        this.call(this.done, this.asyncCompleteListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailure(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.whenFailure(listener);
        if (this.done && !this.success) {
            this.listeners.handleFailure(this.result, this.failure, this.stats);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailure(ResultListener<? super T, ? extends Throwable> listener) {
        this.listeners.whenFailure(listener);
        if (this.done && !this.success) {
            this.listeners.handleFailure(this.result, this.failure);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailureAsync(ContextualResultListener<? super T, ? extends Throwable> listener) {
        this.asyncCtxFailureListener = new AsyncListeners.AsyncCtxResultListener<T>(listener);
        this.call(this.done && !this.success, this.asyncCtxFailureListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailureAsync(ContextualResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncCtxFailureListener = new AsyncListeners.AsyncCtxResultListener<T>(listener, executor);
        this.call(this.done && !this.success, this.asyncCtxFailureListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailureAsync(ResultListener<? super T, ? extends Throwable> listener) {
        this.asyncFailureListener = new AsyncListeners.AsyncResultListener<T>(listener);
        this.call(this.done && !this.success, this.asyncFailureListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenFailureAsync(ResultListener<? super T, ? extends Throwable> listener, ExecutorService executor) {
        this.asyncFailureListener = new AsyncListeners.AsyncResultListener<T>(listener, executor);
        this.call(this.done && !this.success, this.asyncFailureListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccess(ContextualSuccessListener<? super T> listener) {
        this.listeners.whenSuccess(listener);
        if (this.done && this.success) {
            this.listeners.handleSuccess(this.result, this.stats);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccess(SuccessListener<? super T> listener) {
        this.listeners.whenSuccess(listener);
        if (this.done && this.success) {
            this.listeners.handleSuccess(this.result);
        }
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccessAsync(ContextualSuccessListener<? super T> listener) {
        this.asyncCtxSuccessListener = new AsyncListeners.AsyncCtxResultListener<T>(Listeners.resultListenerOf(listener));
        this.call(this.done && this.success, this.asyncCtxSuccessListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccessAsync(ContextualSuccessListener<? super T> listener, ExecutorService executor) {
        this.asyncCtxSuccessListener = new AsyncListeners.AsyncCtxResultListener<T>(Listeners.resultListenerOf(listener), executor);
        this.call(this.done && this.success, this.asyncCtxSuccessListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccessAsync(SuccessListener<? super T> listener) {
        this.asyncSuccessListener = new AsyncListeners.AsyncResultListener<T>(Listeners.resultListenerOf(listener));
        this.call(this.done && this.success, this.asyncSuccessListener);
        return this;
    }

    public synchronized RecurrentFuture<T> whenSuccessAsync(SuccessListener<? super T> listener, ExecutorService executor) {
        this.asyncSuccessListener = new AsyncListeners.AsyncResultListener<T>(Listeners.resultListenerOf(listener), executor);
        this.call(this.done && this.success, this.asyncSuccessListener);
        return this;
    }

    synchronized void complete(T result, Throwable failure, boolean success) {
        this.result = result;
        this.failure = failure;
        this.success = success;
        this.done = true;
        if (success) {
            AsyncListeners.call(this.asyncSuccessListener, this.asyncCtxSuccessListener, result, failure, this.stats, this.scheduler);
        } else {
            AsyncListeners.call(this.asyncFailureListener, this.asyncCtxFailureListener, result, failure, this.stats, this.scheduler);
        }
        AsyncListeners.call(this.asyncCompleteListener, this.asyncCtxCompleteListener, result, failure, this.stats, this.scheduler);
        this.listeners.complete(result, failure, this.stats, success);
        this.circuit.close();
    }

    void initialize(InvocationStats stats) {
        this.stats = stats;
    }

    void setFuture(Future<T> delegate) {
        this.delegate = delegate;
    }

    private void call(boolean condition, AsyncListeners.AsyncCtxResultListener<T> listener) {
        if (condition) {
            AsyncListeners.call(listener, this.result, this.failure, this.stats, this.scheduler);
        }
    }

    private void call(boolean condition, AsyncListeners.AsyncResultListener<T> listener) {
        if (condition) {
            AsyncListeners.call(listener, this.result, this.failure, this.stats, this.scheduler);
        }
    }
}

