/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.AsyncExecution;
import net.jodah.recurrent.AsyncRunnable;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.internal.util.Assert;

abstract class AsyncContextualCallable<T>
implements Callable<T> {
    protected AsyncExecution execution;

    AsyncContextualCallable() {
    }

    static <T> AsyncContextualCallable<T> of(final AsyncCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.prepare();
                    Object result = callable.call(this.execution);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncContextualCallable<T> of(final AsyncRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncContextualCallable<T>(){

            @Override
            public synchronized T call() throws Exception {
                try {
                    this.execution.prepare();
                    runnable.run(this.execution);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncContextualCallable<T> of(final Callable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    Object result = callable.call();
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncContextualCallable<T> of(final CheckedRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    runnable.run();
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncContextualCallable<T> of(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    Object result = callable.call(this.execution);
                    this.execution.completeOrRetry(result, null);
                    return result;
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                    return null;
                }
            }
        };
    }

    static <T> AsyncContextualCallable<T> of(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    runnable.run(this.execution);
                    this.execution.completeOrRetry(null, null);
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncContextualCallable<T> ofFuture(final AsyncCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){
            Semaphore asyncFutureLock = new Semaphore(1);

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    this.asyncFutureLock.acquire();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            try {
                                if (failure != null) {
                                    execution.completeOrRetry(innerResult, failure instanceof CompletionException ? failure.getCause() : failure);
                                }
                            }
                            finally {
                                asyncFutureLock.release();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    try {
                        this.execution.completeOrRetry(null, e);
                    }
                    finally {
                        this.asyncFutureLock.release();
                    }
                }
                return null;
            }
        };
    }

    static <T> AsyncContextualCallable<T> ofFuture(final Callable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    ((CompletableFuture)callable.call()).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    static <T> AsyncContextualCallable<T> ofFuture(final ContextualCallable<CompletableFuture<T>> callable) {
        Assert.notNull(callable, "callable");
        return new AsyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    this.execution.prepare();
                    ((CompletableFuture)callable.call(this.execution)).whenComplete(new BiConsumer<T, Throwable>(){

                        @Override
                        public void accept(T innerResult, Throwable failure) {
                            if (failure != null && failure instanceof CompletionException) {
                                failure = failure.getCause();
                            }
                            execution.completeOrRetry(innerResult, failure);
                        }
                    });
                }
                catch (Exception e) {
                    this.execution.completeOrRetry(null, e);
                }
                return null;
            }
        };
    }

    void initialize(AsyncExecution execution) {
        this.execution = execution;
    }
}

