/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.AsyncCallable;
import net.jodah.recurrent.AsyncContextualCallable;
import net.jodah.recurrent.AsyncExecution;
import net.jodah.recurrent.AsyncRunnable;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Listeners;
import net.jodah.recurrent.RecurrentFuture;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.internal.util.Assert;
import net.jodah.recurrent.util.concurrent.Scheduler;

public class AsyncRecurrent {
    private final RetryPolicy retryPolicy;
    private final Scheduler scheduler;
    private Listeners<?> listeners;

    AsyncRecurrent(RetryPolicy retryPolicy, Scheduler scheduler) {
        this.retryPolicy = retryPolicy;
        this.scheduler = scheduler;
    }

    public <T> RecurrentFuture<T> get(Callable<T> callable) {
        return this.call(AsyncContextualCallable.of(callable), null);
    }

    public <T> RecurrentFuture<T> get(ContextualCallable<T> callable) {
        return this.call(AsyncContextualCallable.of(callable), null);
    }

    public <T> RecurrentFuture<T> getAsync(AsyncCallable<T> callable) {
        return this.call(AsyncContextualCallable.of(callable), null);
    }

    public RecurrentFuture<Void> run(CheckedRunnable runnable) {
        return this.call(AsyncContextualCallable.of(runnable), null);
    }

    public RecurrentFuture<Void> run(ContextualRunnable runnable) {
        return this.call(AsyncContextualCallable.of(runnable), null);
    }

    public RecurrentFuture<Void> runAsync(AsyncRunnable runnable) {
        return this.call(AsyncContextualCallable.of(runnable), null);
    }

    public <T> CompletableFuture<T> future(Callable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
        return response;
    }

    public <T> CompletableFuture<T> future(ContextualCallable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
        return response;
    }

    public <T> CompletableFuture<T> futureAsync(AsyncCallable<CompletableFuture<T>> callable) {
        CompletableFuture response = new CompletableFuture();
        this.call(AsyncContextualCallable.ofFuture(callable), RecurrentFuture.of(response, this.scheduler, this.listeners));
        return response;
    }

    public <T extends Listeners<?>> AsyncRecurrent with(T listeners) {
        this.listeners = Assert.notNull(listeners, "listeners");
        return this;
    }

    private <T> RecurrentFuture<T> call(AsyncContextualCallable<T> callable, RecurrentFuture<T> future) {
        Listeners<?> typedListeners = this.listeners;
        if (future == null) {
            future = new RecurrentFuture(this.scheduler, typedListeners);
        }
        AsyncExecution execution = new AsyncExecution(callable, this.retryPolicy, this.scheduler, future, typedListeners);
        future.initialize(execution);
        callable.initialize(execution);
        try {
            future.setFuture(this.scheduler.schedule(callable, 0L, TimeUnit.MILLISECONDS));
        }
        catch (Throwable t) {
            future.complete(null, t, false);
        }
        return future;
    }
}

