/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.TimeUnit;

public class ExecutionStats {
    final long startTime;
    volatile int executions;

    ExecutionStats(long startTime) {
        this.startTime = startTime;
    }

    ExecutionStats(ExecutionStats stats) {
        this.startTime = stats.startTime;
        this.executions = stats.executions;
    }

    public int getExecutions() {
        return this.executions;
    }

    public long getElapsedMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
    }

    public long getElapsedNanos() {
        return System.nanoTime() - this.startTime;
    }

    public long getStartMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.startTime);
    }

    public long getStartNanos() {
        return this.startTime;
    }

    ExecutionStats copy() {
        return new ExecutionStats(this);
    }
}

