/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.ExecutionStats;
import net.jodah.recurrent.internal.util.Assert;

abstract class SyncContextualCallable<T>
implements Callable<T> {
    protected ExecutionStats stats;

    SyncContextualCallable() {
    }

    void initialize(ExecutionStats stats) {
        this.stats = stats;
    }

    static <T> SyncContextualCallable<T> of(final ContextualCallable<T> callable) {
        Assert.notNull(callable, "callable");
        return new SyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                Object result = callable.call(this.stats);
                return result;
            }
        };
    }

    static <T> SyncContextualCallable<T> of(final ContextualRunnable runnable) {
        Assert.notNull(runnable, "runnable");
        return new SyncContextualCallable<T>(){

            @Override
            public T call() throws Exception {
                runnable.run(this.stats);
                return null;
            }
        };
    }
}

