/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.jodah.recurrent.Callables;
import net.jodah.recurrent.CheckedRunnable;
import net.jodah.recurrent.ContextualCallable;
import net.jodah.recurrent.ContextualRunnable;
import net.jodah.recurrent.Execution;
import net.jodah.recurrent.Listeners;
import net.jodah.recurrent.RecurrentException;
import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.SyncContextualCallable;
import net.jodah.recurrent.internal.util.Assert;

public class SyncRecurrent {
    private final RetryPolicy retryPolicy;
    private Listeners<?> listeners;

    SyncRecurrent(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public <T> T get(Callable<T> callable) {
        return this.call(Assert.notNull(callable, "callable"));
    }

    public <T> T get(ContextualCallable<T> callable) {
        return this.call(SyncContextualCallable.of(callable));
    }

    public void run(CheckedRunnable runnable) {
        this.call(Callables.of(runnable));
    }

    public void run(ContextualRunnable runnable) {
        this.call(SyncContextualCallable.of(runnable));
    }

    public SyncRecurrent with(Listeners<?> listeners) {
        this.listeners = Assert.notNull(listeners, "listeners");
        return this;
    }

    private <T> T call(Callable<T> callable) {
        boolean success;
        Throwable failure;
        boolean shouldRetry;
        boolean completed;
        Execution execution = new Execution(this.retryPolicy);
        if (callable instanceof SyncContextualCallable) {
            ((SyncContextualCallable)callable).initialize(execution);
        }
        Listeners<?> typedListeners = this.listeners;
        Object result = null;
        do {
            try {
                failure = null;
                result = callable.call();
            }
            catch (Throwable t) {
                failure = t;
            }
            completed = execution.complete(result, failure, true);
            success = completed && failure == null;
            boolean bl = shouldRetry = completed ? false : execution.canRetryForInternal(result, failure);
            if (!success && typedListeners != null) {
                typedListeners.handleFailedAttempt(result, failure, execution, null);
            }
            if (!shouldRetry) continue;
            try {
                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(execution.waitTime));
            }
            catch (InterruptedException e) {
                throw new RecurrentException(e);
            }
            if (typedListeners == null) continue;
            typedListeners.handleRetry(result, failure, execution, null);
        } while (!completed && shouldRetry);
        if (typedListeners != null) {
            typedListeners.complete(result, failure, execution, success);
        }
        if (success || failure == null) {
            return result;
        }
        RecurrentException re = failure instanceof RecurrentException ? (RecurrentException)failure : new RecurrentException(failure);
        throw re;
    }
}

