/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import net.joelinn.stripe.error.StripeApiException;
import net.joelinn.stripe.error.card.CardDeclinedException;
import net.joelinn.stripe.error.card.IncorrectNumberException;
import net.joelinn.stripe.error.card.InvalidCvcException;
import net.joelinn.stripe.error.card.InvalidExpiryMonthException;
import net.joelinn.stripe.error.card.InvalidExpiryYearException;
import net.joelinn.stripe.json.StripeModule;
import net.joelinn.stripe.response.ErrorResponse;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class Client {
    protected static final String BASE_URL = "https://api.stripe.com/";
    protected static final String VERSION = "v1";
    protected WebResource service;

    public Client(String apiKey) {
        this(apiKey, false);
    }

    public Client(String apiKey, boolean failOnUnknownProperties) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, failOnUnknownProperties);
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.registerModule((Module)new StripeModule());
        DefaultClientConfig config = new DefaultClientConfig();
        config.getSingletons().add(new JacksonJsonProvider(mapper));
        com.sun.jersey.api.client.Client client = com.sun.jersey.api.client.Client.create((ClientConfig)config);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(apiKey, ""));
        this.service = client.resource(UriBuilder.fromUri((String)"https://api.stripe.com/v1/").build(new Object[0]));
    }

    public <T> T get(String url, Class<T> cls) {
        return this.get(url, cls, null);
    }

    public <T> T get(String url, Class<T> cls, MultivaluedMap<String, String> body) {
        return this.request("GET", url, cls, body, null);
    }

    public <T> T get(String url, Class<T> cls, MultivaluedMap<String, String> body, MultivaluedMap<String, String> queryParams) {
        return this.request("GET", url, cls, body, queryParams);
    }

    public <T> T post(String url, Class<T> cls) {
        return this.request("POST", url, cls);
    }

    public <T> T post(String url, Class<T> cls, MultivaluedMap<String, String> body) {
        return this.request("POST", url, cls, body);
    }

    public <T> T delete(String url, Class<T> cls) {
        return this.delete(url, cls, null, null);
    }

    public <T> T delete(String url, Class<T> cls, MultivaluedMap<String, String> body, MultivaluedMap<String, String> queryParams) {
        return this.request("DELETE", url, cls, body, queryParams);
    }

    public <T> T request(String method, String url, Class<T> cls) {
        return this.request(method, url, cls, null, null);
    }

    public <T> T request(String method, String url, Class<T> cls, MultivaluedMap body) {
        return this.request(method, url, cls, body, null);
    }

    public <T> T request(String method, String url, Class<T> cls, Object body, MultivaluedMap<String, String> queryParams) {
        ClientResponse clientResponse = (ClientResponse)this.getResourceBuilder(url, queryParams).method(method, ClientResponse.class, body);
        int status = clientResponse.getStatus();
        if (status >= 300) {
            this.handleError((ErrorResponse)clientResponse.getEntity(ErrorResponse.class), status);
        }
        return (T)clientResponse.getEntity(cls);
    }

    protected WebResource.Builder getResourceBuilder(String url, MultivaluedMap<String, String> queryParams) {
        WebResource webResource = this.service.path(url);
        if (queryParams != null) {
            webResource = webResource.queryParams(queryParams);
        }
        return (WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/x-www-form-urlencoded");
    }

    protected void handleError(ErrorResponse error, int status) {
        StripeApiException apiException = new StripeApiException(error, status);
        if (error.getType().equals("card_error")) {
            String code = error.getCode();
            if (code.equals("incorrect_number")) {
                throw new IncorrectNumberException(apiException);
            }
            if (code.equals("card_declined")) {
                throw new CardDeclinedException(apiException);
            }
            if (code.equals("invalid_expiry_month")) {
                throw new InvalidExpiryMonthException(apiException);
            }
            if (code.equals("invalid_expiry_year")) {
                throw new InvalidExpiryYearException(apiException);
            }
            if (code.equals("invalid_cvc")) {
                throw new InvalidCvcException(apiException);
            }
        }
        throw apiException;
    }
}

