/*
 * Decompiled with CFR 0.152.
 */
package net.joelinn.stripe;

import net.joelinn.stripe.Client;
import net.joelinn.stripe.api.Accounts;
import net.joelinn.stripe.api.ApplicationFees;
import net.joelinn.stripe.api.Balance;
import net.joelinn.stripe.api.Cards;
import net.joelinn.stripe.api.Charges;
import net.joelinn.stripe.api.Coupons;
import net.joelinn.stripe.api.Customers;
import net.joelinn.stripe.api.Discounts;
import net.joelinn.stripe.api.Disputes;
import net.joelinn.stripe.api.Events;
import net.joelinn.stripe.api.InvoiceItems;
import net.joelinn.stripe.api.Invoices;
import net.joelinn.stripe.api.Plans;
import net.joelinn.stripe.api.Recipients;
import net.joelinn.stripe.api.Refunds;
import net.joelinn.stripe.api.Subscriptions;
import net.joelinn.stripe.api.Tokens;
import net.joelinn.stripe.api.Transfers;

public class Stripe {
    protected final Accounts accounts;
    protected final ApplicationFees applicationFees;
    protected final Balance balance;
    protected final Cards cards;
    protected final Charges charges;
    protected final Coupons coupons;
    protected final Customers customers;
    protected final Discounts discounts;
    protected final Disputes disputes;
    protected final Events events;
    protected final InvoiceItems invoiceItems;
    protected final Invoices invoices;
    protected final Plans plans;
    protected final Recipients recipients;
    protected final Refunds refunds;
    protected final Subscriptions subscriptions;
    protected final Tokens tokens;
    protected final Transfers transfers;
    protected final Client client;

    public Stripe(String apiKey) {
        this.client = new Client(apiKey);
        this.accounts = new Accounts(this.client);
        this.applicationFees = new ApplicationFees(this.client);
        this.balance = new Balance(this.client);
        this.cards = new Cards(this.client);
        this.charges = new Charges(this.client);
        this.coupons = new Coupons(this.client);
        this.customers = new Customers(this.client);
        this.discounts = new Discounts(this.client);
        this.disputes = new Disputes(this.client);
        this.events = new Events(this.client);
        this.invoiceItems = new InvoiceItems(this.client);
        this.invoices = new Invoices(this.client);
        this.plans = new Plans(this.client);
        this.recipients = new Recipients(this.client);
        this.refunds = new Refunds(this.client);
        this.subscriptions = new Subscriptions(this.client);
        this.tokens = new Tokens(this.client);
        this.transfers = new Transfers(this.client);
    }

    public Accounts accounts() {
        return this.accounts;
    }

    public ApplicationFees applicationFees() {
        return this.applicationFees;
    }

    public Balance balance() {
        return this.balance;
    }

    public Cards cards() {
        return this.cards;
    }

    public Charges charges() {
        return this.charges;
    }

    public Coupons coupons() {
        return this.coupons;
    }

    public Customers customers() {
        return this.customers;
    }

    public Discounts discounts() {
        return this.discounts;
    }

    public Disputes disputes() {
        return this.disputes;
    }

    public Events events() {
        return this.events;
    }

    public InvoiceItems invoiceItems() {
        return this.invoiceItems;
    }

    public Invoices invoices() {
        return this.invoices;
    }

    public Plans plans() {
        return this.plans;
    }

    public Recipients recipients() {
        return this.recipients;
    }

    public Refunds refunds() {
        return this.refunds;
    }

    public Subscriptions subscriptions() {
        return this.subscriptions;
    }

    public Tokens tokens() {
        return this.tokens;
    }

    public Transfers transfers() {
        return this.transfers;
    }

    public Client getClient() {
        return this.client;
    }
}

